/*
 * Decompiled with CFR 0.152.
 */
package de.focus_shift.jollyday.core;

import de.focus_shift.jollyday.core.CalendarHierarchy;
import de.focus_shift.jollyday.core.Holiday;
import de.focus_shift.jollyday.core.HolidayCalendar;
import de.focus_shift.jollyday.core.HolidayType;
import de.focus_shift.jollyday.core.ManagerParameter;
import de.focus_shift.jollyday.core.ManagerParameters;
import de.focus_shift.jollyday.core.caching.Cache;
import de.focus_shift.jollyday.core.caching.HolidayManagerValueHandler;
import de.focus_shift.jollyday.core.configuration.ConfigurationProviderManager;
import de.focus_shift.jollyday.core.parser.functions.CalendarToLocalDate;
import de.focus_shift.jollyday.core.spi.ConfigurationService;
import de.focus_shift.jollyday.core.util.CalendarUtil;
import java.time.LocalDate;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HolidayManager {
    private static final Logger LOG = LoggerFactory.getLogger(HolidayManager.class);
    private static boolean cachingEnabled = true;
    private static final Cache<HolidayManager> HOLIDAY_MANAGER_CACHE = new Cache();
    private static final ConfigurationProviderManager CONFIGURATION_MANAGER_PROVIDER = new ConfigurationProviderManager();
    private final Cache<Set<Holiday>> holidayCache = new Cache();
    protected final CalendarUtil calendarUtil = new CalendarUtil();
    private ConfigurationService configurationService;
    private ManagerParameter managerParameter;

    public static HolidayManager getInstance() {
        return HolidayManager.getInstance(ManagerParameters.create((String)null, null));
    }

    public static HolidayManager getInstance(Properties properties) {
        return HolidayManager.getInstance(ManagerParameters.create((String)null, properties));
    }

    public static HolidayManager getInstance(ManagerParameter parameter) {
        return HolidayManager.createManager(parameter);
    }

    private static HolidayManager createManager(ManagerParameter parameter) {
        LOG.debug("Creating HolidayManager for calendar '{}'. Caching enabled: {}", (Object)parameter, (Object)HolidayManager.isManagerCachingEnabled());
        CONFIGURATION_MANAGER_PROVIDER.mergeConfigurationProperties(parameter);
        String managerImplClassName = HolidayManager.readManagerImplClassName(parameter);
        HolidayManagerValueHandler holidayManagerValueHandler = new HolidayManagerValueHandler(parameter, managerImplClassName);
        if (HolidayManager.isManagerCachingEnabled()) {
            return HOLIDAY_MANAGER_CACHE.get(holidayManagerValueHandler);
        }
        return holidayManagerValueHandler.createValue();
    }

    private static String readManagerImplClassName(ManagerParameter parameter) {
        String className = parameter.getManagerImplClassName();
        if (className == null) {
            throw new IllegalStateException("Missing configuration 'manager.impl'. Cannot create manager.");
        }
        return className;
    }

    public static void setManagerCachingEnabled(boolean managerCachingEnabled) {
        cachingEnabled = managerCachingEnabled;
    }

    public static boolean isManagerCachingEnabled() {
        return cachingEnabled;
    }

    public static void clearManagerCache() {
        HOLIDAY_MANAGER_CACHE.clear();
    }

    public boolean isHoliday(Calendar c, HolidayType holidayType, String ... args) {
        return this.isHoliday(new CalendarToLocalDate().apply(c), holidayType, args);
    }

    public boolean isHoliday(Calendar c, String ... args) {
        return this.isHoliday(c, (HolidayType)null, args);
    }

    public boolean isHoliday(final LocalDate c, HolidayType holidayType, final String ... args) {
        final StringBuilder keyBuilder = new StringBuilder();
        keyBuilder.append(c.getYear());
        for (String arg : args) {
            keyBuilder.append("_");
            keyBuilder.append(arg);
        }
        Set<Holiday> holidays = this.holidayCache.get(new Cache.ValueHandler<Set<Holiday>>(){

            @Override
            public String getKey() {
                return keyBuilder.toString();
            }

            @Override
            public Set<Holiday> createValue() {
                return HolidayManager.this.getHolidays(c.getYear(), args);
            }
        });
        return this.calendarUtil.contains(holidays, c, holidayType);
    }

    public boolean isHoliday(LocalDate c, String ... args) {
        return this.isHoliday(c, (HolidayType)null, args);
    }

    public static Set<String> getSupportedCalendarCodes() {
        HashSet<String> supportedCalendars = new HashSet<String>();
        for (HolidayCalendar c : HolidayCalendar.values()) {
            supportedCalendars.add(c.getId());
        }
        return supportedCalendars;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public ConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    public ManagerParameter getManagerParameter() {
        return this.managerParameter;
    }

    public void init(ManagerParameter parameters) {
        this.managerParameter = parameters;
        this.doInit();
    }

    public abstract void doInit();

    public abstract Set<Holiday> getHolidays(int var1, String ... var2);

    public abstract Set<Holiday> getHolidays(LocalDate var1, LocalDate var2, String ... var3);

    public abstract CalendarHierarchy getCalendarHierarchy();
}

