/*
 * Decompiled with CFR 0.152.
 */
package de.focus_shift.parser.functions;

import de.focus_shift.spi.FixedWeekdayRelativeToFixed;
import de.focus_shift.spi.Relation;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalAdjusters;
import java.util.function.Function;
import org.threeten.extra.Days;

public class FindWeekDayRelativeToDate
implements Function<FixedWeekdayRelativeToFixed, LocalDate> {
    private final LocalDate date;

    public FindWeekDayRelativeToDate(LocalDate date) {
        this.date = date;
    }

    @Override
    public LocalDate apply(FixedWeekdayRelativeToFixed fixedWeekdayRelativeToFixed) {
        LocalDate result = this.moveDateToFirstOccurrenceOfWeekday(fixedWeekdayRelativeToFixed, this.date);
        int days = this.determineNumberOfDays(fixedWeekdayRelativeToFixed);
        result = fixedWeekdayRelativeToFixed.when() == Relation.AFTER ? result.plusDays(days) : result.minusDays(days);
        return result;
    }

    private LocalDate moveDateToFirstOccurrenceOfWeekday(FixedWeekdayRelativeToFixed f, LocalDate day) {
        TemporalAdjuster adjuster;
        switch (f.when()) {
            case AFTER: {
                adjuster = TemporalAdjusters.next(f.weekday());
                break;
            }
            case BEFORE: {
                adjuster = TemporalAdjusters.previous(f.weekday());
                break;
            }
            case CLOSEST: {
                adjuster = FindWeekDayRelativeToDate.closest(f.weekday());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported relative adjustment: " + f.when());
            }
        }
        return day.with(adjuster);
    }

    private int determineNumberOfDays(FixedWeekdayRelativeToFixed f) {
        if (f.when() == Relation.CLOSEST) {
            return 0;
        }
        switch (f.which()) {
            case SECOND: {
                return 7;
            }
            case THIRD: {
                return 14;
            }
            case FOURTH: {
                return 21;
            }
        }
        return 0;
    }

    private static TemporalAdjuster closest(DayOfWeek dayOfWeek) {
        return temporal -> {
            int nextDays;
            Temporal previous = temporal.with(TemporalAdjusters.previousOrSame(dayOfWeek));
            Temporal next = temporal.with(TemporalAdjusters.nextOrSame(dayOfWeek));
            int previousDays = Days.between((Temporal)temporal, (Temporal)previous).abs().getAmount();
            return previousDays <= (nextDays = Days.between((Temporal)temporal, (Temporal)next).abs().getAmount()) ? previous : next;
        };
    }
}

