/*
 * Decompiled with CFR 0.152.
 */
package de.focus_shift.impl;

import de.focus_shift.CalendarHierarchy;
import de.focus_shift.Holiday;
import de.focus_shift.HolidayManager;
import de.focus_shift.parser.HolidayParser;
import de.focus_shift.spi.Configuration;
import de.focus_shift.spi.Holidays;
import de.focus_shift.util.ClassLoadingUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.time.LocalDate;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultHolidayManager
extends HolidayManager {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultHolidayManager.class);
    private static final String PARSER_IMPL_PREFIX = "parser.impl.";
    private final Map<String, HolidayParser> parserCache = new HashMap<String, HolidayParser>();
    protected Configuration configuration;
    private final ClassLoadingUtil classLoadingUtil = new ClassLoadingUtil();

    @Override
    public Set<Holiday> getHolidays(int year, String ... args) {
        Set<Holiday> holidaySet = Collections.synchronizedSet(new HashSet());
        this.getHolidays(year, this.configuration, holidaySet, args);
        return holidaySet;
    }

    @Override
    public Set<Holiday> getHolidays(LocalDate startDateInclusive, LocalDate endDateInclusive, String ... args) {
        Objects.requireNonNull(startDateInclusive, "startDateInclusive is null");
        Objects.requireNonNull(endDateInclusive, "endInclusive is null");
        HashSet<Holiday> holidays = new HashSet<Holiday>();
        for (int year = startDateInclusive.getYear(); year <= endDateInclusive.getYear(); ++year) {
            Set<Holiday> yearHolidays = this.getHolidays(year, args);
            for (Holiday h : yearHolidays) {
                if (startDateInclusive.isAfter(h.getDate()) || endDateInclusive.isBefore(h.getDate())) continue;
                holidays.add(h);
            }
        }
        return holidays;
    }

    private void getHolidays(int year, Configuration configuration, Set<Holiday> holidaySet, String ... args) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Adding holidays for {}", (Object)configuration.description());
        }
        this.parseHolidays(year, holidaySet, configuration.holidays());
        if (args != null && args.length > 0) {
            String hierarchy = args[0];
            configuration.subConfigurations().filter(sub -> hierarchy.equalsIgnoreCase(sub.hierarchy())).forEach(config -> this.getHolidays(year, (Configuration)config, holidaySet, this.copyOfRange(args, 1, args.length)));
        }
    }

    private String[] copyOfRange(String[] original, int from, int to) {
        int newLength = to - from;
        if (newLength < 0) {
            throw new IllegalArgumentException(from + " > " + to);
        }
        String[] copy = new String[newLength];
        System.arraycopy(original, from, copy, 0, Math.min(original.length - from, newLength));
        return copy;
    }

    private void parseHolidays(int year, Set<Holiday> holidays, Holidays config) {
        Collection<HolidayParser> parsers = this.getParsers(config);
        for (HolidayParser p : parsers) {
            holidays.addAll(p.parse(year, config));
        }
    }

    private Collection<HolidayParser> getParsers(Holidays config) {
        HashSet<HolidayParser> parsers = new HashSet<HolidayParser>();
        try {
            Method[] declaredMethods;
            for (Method declaredMethod : declaredMethods = config.getClass().getDeclaredMethods()) {
                HolidayParser holidayParser;
                if (!(declaredMethod.getGenericReturnType() instanceof ParameterizedType)) continue;
                ParameterizedType parameterizedType = (ParameterizedType)declaredMethod.getGenericReturnType();
                Type actualTypeArgument = parameterizedType.getActualTypeArguments()[0];
                List holidays = (List)declaredMethod.invoke((Object)config, new Object[0]);
                if (holidays.isEmpty() || (holidayParser = this.instantiateParser(actualTypeArgument.getTypeName())) == null) continue;
                parsers.add(holidayParser);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot create parsers.", e);
        }
        return parsers;
    }

    private HolidayParser instantiateParser(String className) throws ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        HolidayParser holidayParser = this.parserCache.get(className);
        if (holidayParser == null) {
            String propName = PARSER_IMPL_PREFIX + className;
            String parserClassName = this.getManagerParameter().getProperty(propName);
            if (parserClassName != null) {
                Class<?> parserClass = this.classLoadingUtil.loadClass(parserClassName);
                holidayParser = (HolidayParser)parserClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                this.parserCache.put(className, holidayParser);
            }
        }
        return holidayParser;
    }

    @Override
    public void doInit() {
        this.configuration = this.getConfigurationService().getConfiguration(this.getManagerParameter());
        DefaultHolidayManager.validateConfigurationHierarchy(this.configuration);
        DefaultHolidayManager.logHierarchy(this.configuration, 0);
    }

    protected static void logHierarchy(Configuration configuration, int level) {
        if (LOG.isDebugEnabled()) {
            StringBuilder space = new StringBuilder();
            space.append("-".repeat(level));
            LOG.debug("{} {} ({}).", new Object[]{space, configuration.description(), configuration.hierarchy()});
            configuration.subConfigurations().forEach(config -> DefaultHolidayManager.logHierarchy(config, level + 1));
        }
    }

    protected static void validateConfigurationHierarchy(Configuration c) {
        HashMap hierarchyMap = new HashMap();
        HashSet multipleHierarchies = new HashSet();
        c.subConfigurations().forEach(subConfig -> {
            String hierarchy = subConfig.hierarchy();
            if (!hierarchyMap.containsKey(hierarchy)) {
                hierarchyMap.put(hierarchy, 1);
            } else {
                int count = (Integer)hierarchyMap.get(hierarchy);
                hierarchyMap.put(hierarchy, ++count);
                multipleHierarchies.add(hierarchy);
            }
        });
        if (!multipleHierarchies.isEmpty()) {
            StringBuilder msg = new StringBuilder();
            msg.append("Configuration for ").append(c.hierarchy()).append(" contains  multiple SubConfigurations with the same hierarchy id. ");
            for (String hierarchy : multipleHierarchies) {
                msg.append(hierarchy).append(" ").append(((Integer)hierarchyMap.get(hierarchy)).toString()).append(" times ");
            }
            throw new IllegalArgumentException(msg.toString().trim());
        }
        c.subConfigurations().forEach(DefaultHolidayManager::validateConfigurationHierarchy);
    }

    @Override
    public CalendarHierarchy getCalendarHierarchy() {
        return DefaultHolidayManager.createConfigurationHierarchy(this.configuration, null);
    }

    private static CalendarHierarchy createConfigurationHierarchy(Configuration c, CalendarHierarchy h) {
        CalendarHierarchy hierarchy = new CalendarHierarchy(h, c.hierarchy());
        hierarchy.setFallbackDescription(c.description());
        c.subConfigurations().forEach(sub -> {
            CalendarHierarchy subHierarchy = DefaultHolidayManager.createConfigurationHierarchy(sub, hierarchy);
            hierarchy.getChildren().put(subHierarchy.getId(), subHierarchy);
        });
        return hierarchy;
    }
}

