/*
 * Decompiled with CFR 0.152.
 */
package de.focus_shift.caching;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class Cache<V> {
    private final Map<String, V> cachingMap = new ConcurrentHashMap<String, V>();

    public V get(ValueHandler<V> valueHandler) {
        String key = valueHandler.getKey();
        V value = this.cachingMap.get(key);
        return (V)(value != null ? value : this.cachingMap.computeIfAbsent(key, k -> valueHandler.createValue()));
    }

    public void clear() {
        this.cachingMap.clear();
    }

    public static interface ValueHandler<V> {
        public String getKey();

        public V createValue();
    }
}

