/*
 * Decompiled with CFR 0.152.
 */
package de.fluxparticle.jpackage;

import com.github.javaparser.ParserConfiguration;
import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.modules.ModuleDeclaration;
import com.github.javaparser.ast.modules.ModuleExportsDirective;
import com.github.javaparser.ast.modules.ModuleRequiresDirective;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.function.Function;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.zip.ZipEntry;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.transfer.artifact.ArtifactCoordinate;
import org.apache.maven.shared.transfer.artifact.DefaultArtifactCoordinate;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResolver;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResolverException;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResult;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.ModuleVisitor;

@Mojo(name="image", requiresDependencyResolution=ResolutionScope.RUNTIME)
@Execute(phase=LifecyclePhase.COMPILE)
public class BuildImage
extends AbstractMojo {
    private static final Path JAVA_HOME = Path.of(System.getProperty("java.home"), new String[0]);
    @Component
    private ArtifactResolver artifactResolver;
    @Parameter(defaultValue="${project}", required=true)
    private MavenProject project;
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    private MavenSession session;
    @Parameter(property="skip", readonly=true)
    private boolean skip;
    @Parameter(property="name", readonly=true)
    private String name;
    @Parameter(property="mainClass", readonly=true)
    private String mainClass;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            return;
        }
        if (this.name == null) {
            throw new MojoFailureException("name required");
        }
        if (this.mainClass == null) {
            throw new MojoFailureException("mainClass required");
        }
        try {
            String modulePath;
            String version = this.project.getArtifact().getVersion().replace("-SNAPSHOT", "");
            String target = this.project.getBuild().getDirectory();
            Path modulesDir = Path.of(target, "modules");
            List<String> classpathElements = this.processJars(this.project.getRuntimeClasspathElements(), modulesDir);
            Path appDir = Path.of(target, this.name + ".app");
            if (Files.exists(appDir, new LinkOption[0])) {
                System.out.println("Deleting: " + appDir);
                BuildImage.deleteDir(appDir);
            }
            if (!BuildImage.jPackage(this.name, version, modulePath = String.join((CharSequence)":", classpathElements), this.mainClass, target)) {
                throw new MojoExecutionException("jpackage error");
            }
        }
        catch (IOException | InterruptedException | DependencyResolutionRequiredException e) {
            throw new MojoExecutionException(e.toString(), (Exception)e);
        }
    }

    private List<String> processJars(List<String> classpathElements, Path modulesDir) throws IOException, InterruptedException {
        ArrayList<String> result = new ArrayList<String>();
        ArrayList<List<String>> lines = new ArrayList<List<String>>();
        lines.add(Arrays.asList("classpathElements:", "modular:"));
        for (int i = 0; i < classpathElements.size(); ++i) {
            String modular;
            String classpathElement = classpathElements.get(i);
            Path path = Path.of(classpathElement, new String[0]);
            String fileName = path.getFileName().toString();
            if (!fileName.endsWith(".jar")) {
                result.add(classpathElement);
                continue;
            }
            ArrayList<String> line = new ArrayList<String>();
            line.add(fileName);
            if (BuildImage.isModular(classpathElement)) {
                result.add(classpathElement);
                modular = "yes";
            } else {
                String newElement = null;
                String action = null;
                if (fileName.startsWith("kotlin-stdlib-")) {
                    newElement = this.replaceKotlinStdLib(fileName);
                    action = "replaced";
                }
                if (fileName.startsWith("javafx-")) {
                    newElement = "";
                }
                if (newElement == null) {
                    String modulePath = classpathElements.stream().filter(p -> p.endsWith(".jar")).filter(p -> !p.equals(path.toString())).collect(Collectors.joining(":"));
                    newElement = BuildImage.fix(modulesDir, modulePath, path);
                    action = "fixed";
                }
                if (newElement == null) {
                    modular = "no";
                } else if (newElement.isEmpty()) {
                    modular = "removed";
                } else {
                    result.add(newElement);
                    modular = action;
                }
            }
            line.add(modular);
            lines.add(line);
        }
        BuildImage.printLines(lines);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String fix(Path modulesDir, String modulePath, Path jar) throws IOException, InterruptedException {
        String fileName = jar.getFileName().toString();
        Path target = modulesDir.resolve(fileName);
        if (Files.exists(target, new LinkOption[0])) {
            System.out.println("Already Fixed: " + fileName);
        } else {
            try {
                System.out.println("Fix: " + jar);
                if (!BuildImage.jDeps(modulesDir, modulePath, jar)) {
                    String string = null;
                    return string;
                }
                int splitVersion = fileName.lastIndexOf(45);
                String moduleName = fileName.substring(0, splitVersion).replace('-', '.');
                Path mod = modulesDir.resolve(moduleName);
                Path moduleInfo = mod.resolve("module-info.java");
                BuildImage.patch(jar, moduleInfo, target);
            }
            finally {
                System.out.println();
            }
        }
        return target.toString();
    }

    private static void extract(Path jar, Path out) throws IOException {
        BuildImage.deleteDir(out);
        System.out.println("Extract: " + jar);
        JarFile jarFile = new JarFile(jar.toString());
        Iterator<JarEntry> iterator = jarFile.entries().asIterator();
        while (iterator.hasNext()) {
            JarEntry entry = iterator.next();
            String name = entry.getName();
            Path path = out.resolve(name);
            if (name.endsWith("/")) {
                Files.createDirectories(path, new FileAttribute[0]);
                continue;
            }
            Files.copy(jarFile.getInputStream(entry), path, new CopyOption[0]);
        }
    }

    private static void pack(final Path out, Path jar) throws IOException {
        System.out.println("Pack: " + jar);
        try (final JarOutputStream target = new JarOutputStream(new FileOutputStream(jar.toString()));){
            Files.walkFileTree(out, (FileVisitor<? super Path>)new FileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    JarEntry entry = new JarEntry(out.relativize(dir).toString() + "/");
                    target.putNextEntry(entry);
                    target.closeEntry();
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    JarEntry entry = new JarEntry(out.relativize(file).toString());
                    target.putNextEntry(entry);
                    Files.copy(file, target);
                    target.closeEntry();
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    return FileVisitResult.CONTINUE;
                }
            });
        }
    }

    private static boolean jDeps(Path modulesDir, String modulePath, Path path) throws IOException, InterruptedException {
        Path jDepsBinary = JAVA_HOME.resolve("bin/jdeps");
        String[] cmdArray = new String[]{jDepsBinary.toString(), "--generate-module-info", modulesDir.toString(), "--module-path", modulePath, path.toString()};
        return BuildImage.exec(cmdArray);
    }

    private String replaceKotlinStdLib(String fileName) {
        String element;
        DefaultProjectBuildingRequest buildingRequest = new DefaultProjectBuildingRequest(this.session.getProjectBuildingRequest());
        DefaultArtifactCoordinate artifactCoordinate = this.toArtifactCoordinate(fileName);
        artifactCoordinate.setClassifier("modular");
        try {
            ArtifactResult artifactResult = this.artifactResolver.resolveArtifact((ProjectBuildingRequest)buildingRequest, (ArtifactCoordinate)artifactCoordinate);
            element = artifactResult.getArtifact().getFile().toString();
        }
        catch (IllegalArgumentException | ArtifactResolverException e) {
            element = null;
        }
        return element;
    }

    private static void deleteDir(Path dir) throws IOException {
        Files.walkFileTree(dir, (FileVisitor<? super Path>)new FileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private static void printLines(List<List<String>> lines) {
        Map<Integer, Integer> cols = lines.stream().flatMap(line -> IntStream.range(0, line.size()).boxed().collect(Collectors.toMap(Function.identity(), idx -> ((String)line.get((int)idx)).length())).entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, Math::max));
        for (List<String> line2 : lines) {
            StringBuilder sb = new StringBuilder();
            String delimiter = "";
            for (int i = 0; i < line2.size(); ++i) {
                sb.append(delimiter);
                delimiter = "  ";
                String str = line2.get(i);
                sb.append(str);
                sb.append(" ".repeat(cols.get(i) - str.length()));
            }
            System.out.println(sb);
        }
    }

    private static boolean jPackage(String name, String version, String modulePath, String mainClass, String target) throws IOException, InterruptedException {
        Path jPackageBinary = JAVA_HOME.resolve("bin/jpackage");
        CharSequence[] cmdArray = new String[]{jPackageBinary.toString(), "--type", "app-image", "--name", name, "--app-version", version, "--module-path", modulePath, "--module", mainClass, "--dest", target};
        System.out.println(String.join((CharSequence)" ", cmdArray));
        return BuildImage.exec((String[])cmdArray);
    }

    private static boolean javaCompiler(String modulePath, Path moduleInfo, Path out) throws IOException, InterruptedException {
        System.out.println("Compile: " + moduleInfo);
        Path javaCompilerBinary = JAVA_HOME.resolve("bin/javac");
        String[] cmdArray = new String[]{javaCompilerBinary.toString(), "--module-path", modulePath, "-d", out.toString(), moduleInfo.toString()};
        return BuildImage.exec(cmdArray);
    }

    private static void patch(Path inputJar, Path moduleInfo, Path outputJar) {
        System.out.println("Compile (In-Memory): " + moduleInfo);
        try {
            CompilationUnit compilationUnit = StaticJavaParser.parse((Path)moduleInfo);
            ModuleDeclaration module = (ModuleDeclaration)compilationUnit.getModule().get();
            ClassWriter classWriter = new ClassWriter(0);
            classWriter.visit(53, 32768, "module-info", null, null, null);
            ModuleVisitor mv = classWriter.visitModule(module.getNameAsString(), 4096, null);
            for (ModuleRequiresDirective requires : module.findAll(ModuleRequiresDirective.class)) {
                mv.visitRequire(requires.getName().asString(), 0, null);
            }
            for (ModuleExportsDirective export : module.findAll(ModuleExportsDirective.class)) {
                mv.visitExport(export.getNameAsString().replace('.', '/'), 0, (String[])export.getModuleNames().stream().map(Node::toString).toArray(String[]::new));
            }
            mv.visitRequire("java.base", 32768, null);
            mv.visitEnd();
            classWriter.visitEnd();
            byte[] bytes = classWriter.toByteArray();
            try (JarOutputStream targetStream = new JarOutputStream(new FileOutputStream(outputJar.toString()));){
                JarEntry entry = new JarEntry("module-info.class");
                targetStream.putNextEntry(entry);
                targetStream.write(bytes);
                targetStream.closeEntry();
                JarFile jarFile = new JarFile(inputJar.toString());
                Iterator<JarEntry> iterator = jarFile.entries().asIterator();
                while (iterator.hasNext()) {
                    JarEntry entry2 = iterator.next();
                    String name = entry2.getName();
                    if (name.endsWith("/")) {
                        targetStream.putNextEntry(entry2);
                        targetStream.closeEntry();
                        continue;
                    }
                    targetStream.putNextEntry(entry2);
                    try (InputStream stream = jarFile.getInputStream(entry2);){
                        stream.transferTo(targetStream);
                    }
                    targetStream.closeEntry();
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean exec(String[] cmdArray) throws IOException, InterruptedException {
        String line;
        Process process = new ProcessBuilder(cmdArray).inheritIO().start();
        try (Scanner sc = new Scanner(process.getInputStream());){
            while (sc.hasNextLine()) {
                line = sc.nextLine();
                System.out.println(line);
            }
        }
        if (process.waitFor() != 0) {
            sc = new Scanner(process.getErrorStream());
            try {
                while (sc.hasNextLine()) {
                    line = sc.nextLine();
                    System.out.println(line);
                }
            }
            finally {
                sc.close();
            }
            return false;
        }
        return true;
    }

    private DefaultArtifactCoordinate toArtifactCoordinate(String fileName) {
        DefaultArtifactCoordinate artifactCoordinate = new DefaultArtifactCoordinate();
        int splitVersion = fileName.lastIndexOf(45);
        int splitExtension = fileName.lastIndexOf(46);
        artifactCoordinate.setGroupId("org.jetbrains.kotlin");
        artifactCoordinate.setArtifactId(fileName.substring(0, splitVersion));
        artifactCoordinate.setVersion(fileName.substring(splitVersion + 1, splitExtension));
        artifactCoordinate.setExtension(fileName.substring(splitExtension + 1));
        return artifactCoordinate;
    }

    private static boolean isModular(String jar) throws IOException {
        return new JarFile(jar).stream().anyMatch(jarEntry -> jarEntry.getName().equals("module-info.class"));
    }

    private static List<String> getVersions(String jar) throws IOException {
        JarFile jarFile = new JarFile(jar);
        Manifest manifest = jarFile.getManifest();
        System.out.println("manifest = " + manifest.getMainAttributes().keySet());
        String prefixVersions = "META-INF/versions/";
        return jarFile.stream().map(ZipEntry::toString).filter(s -> s.startsWith(prefixVersions)).map(s -> s.substring(prefixVersions.length())).collect(Collectors.toList());
    }

    static {
        StaticJavaParser.getConfiguration().setLanguageLevel(ParserConfiguration.LanguageLevel.JAVA_9);
    }
}

