/*
 * Decompiled with CFR 0.152.
 */
package de.fluxparticle.jpackage;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Scanner;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="image", requiresDependencyResolution=ResolutionScope.RUNTIME)
@Execute(phase=LifecyclePhase.COMPILE)
public class BuildImage
extends AbstractMojo {
    @Parameter(defaultValue="${project}", required=true)
    private MavenProject project;
    @Parameter(property="name", required=true, readonly=true)
    private String name;
    @Parameter(property="mainClass", required=true, readonly=true)
    private String mainClass;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Path javaHome = Path.of(System.getProperty("java.home"), new String[0]);
        Path jpackage = javaHome.resolve("bin/jpackage");
        try {
            String modulePath = String.join((CharSequence)":", this.project.getRuntimeClasspathElements());
            String target = this.project.getBuild().getDirectory();
            String[] cmdarray = new String[]{jpackage.toString(), "--type", "app-image", "--name", this.name, "--module-path", modulePath, "--module", this.mainClass, "--dest", target};
            Process process = Runtime.getRuntime().exec(cmdarray);
            try (Scanner sc = new Scanner(process.getInputStream());){
                while (sc.hasNextLine()) {
                    String line = sc.nextLine();
                    System.out.println(line);
                }
            }
        }
        catch (IOException | DependencyResolutionRequiredException e) {
            throw new MojoExecutionException(e.toString(), (Exception)e);
        }
    }
}

