/*
 * Decompiled with CFR 0.152.
 */
package de.floydkretschmar.fixturize.stategies.creation;

import de.floydkretschmar.fixturize.annotations.FixtureConstructor;
import de.floydkretschmar.fixturize.domain.Constant;
import de.floydkretschmar.fixturize.domain.CreationMethod;
import de.floydkretschmar.fixturize.domain.TypeMetadata;
import de.floydkretschmar.fixturize.stategies.constants.ConstantDefinitionMap;
import de.floydkretschmar.fixturize.stategies.creation.CreationMethodGenerationStrategy;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import javax.lang.model.element.TypeElement;

public class ConstructorCreationMethodStrategy
implements CreationMethodGenerationStrategy {
    @Override
    public Collection<CreationMethod> generateCreationMethods(TypeElement element, ConstantDefinitionMap constantMap, TypeMetadata metadata) {
        return Arrays.stream((FixtureConstructor[])element.getAnnotationsByType(FixtureConstructor.class)).map(annotation -> {
            Collection<Constant> correspondingConstants = constantMap.getMatchingConstants(Arrays.asList(annotation.constructorParameters()));
            String className = "%s%s".formatted(metadata.getSimpleClassNameWithoutGeneric(), metadata.isGeneric() ? "<>" : "");
            return CreationMethod.builder().returnType(metadata.getSimpleClassName()).returnValue(ConstructorCreationMethodStrategy.createReturnValueString(className, correspondingConstants)).name(annotation.methodName()).build();
        }).toList();
    }

    private static String createReturnValueString(String className, Collection<Constant> correspondingConstants) {
        String parameterString = correspondingConstants.stream().map(Constant::getName).collect(Collectors.joining(", "));
        return "new %s(%s)".formatted(className, parameterString);
    }
}

