/*
 * Decompiled with CFR 0.152.
 */
package de.floydkretschmar.fixturize.stategies.creation;

import de.floydkretschmar.fixturize.ElementUtils;
import de.floydkretschmar.fixturize.FormattingConstants;
import de.floydkretschmar.fixturize.annotations.FixtureBuilder;
import de.floydkretschmar.fixturize.domain.Constant;
import de.floydkretschmar.fixturize.domain.CreationMethod;
import de.floydkretschmar.fixturize.domain.TypeMetadata;
import de.floydkretschmar.fixturize.exceptions.FixtureCreationException;
import de.floydkretschmar.fixturize.stategies.constants.ConstantDefinitionMap;
import de.floydkretschmar.fixturize.stategies.creation.CreationMethodGenerationStrategy;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.util.ElementFilter;

public class BuilderCreationMethodStrategy
implements CreationMethodGenerationStrategy {
    @Override
    public Collection<CreationMethod> generateCreationMethods(TypeElement element, ConstantDefinitionMap constantMap, TypeMetadata metadata) {
        return Arrays.stream((FixtureBuilder[])element.getAnnotationsByType(FixtureBuilder.class)).map(annotation -> {
            Collection<Object> correspondingConstants = annotation.usedSetters().length == 0 ? constantMap.values().stream().toList() : constantMap.getMatchingConstants(Arrays.asList(annotation.usedSetters()));
            String returnType = "%s.%sBuilder%s".formatted(metadata.getSimpleClassNameWithoutGeneric(), metadata.getSimpleClassNameWithoutGeneric(), metadata.getGenericPart());
            String buildMethod = "%s%s".formatted(metadata.getGenericPart(), annotation.builderMethod());
            return CreationMethod.builder().returnType(returnType).returnValue(BuilderCreationMethodStrategy.createReturnValueString(element, metadata.getSimpleClassNameWithoutGeneric(), buildMethod, correspondingConstants)).name(annotation.methodName()).build();
        }).toList();
    }

    private static Map<String, String> getConstantToSetterMap(Element element, String buildMethodName, Collection<Constant> correspondingConstants) {
        List<String> fieldNames = correspondingConstants.stream().map(Constant::getOriginalFieldName).toList();
        ExecutableElement buildMethod = ElementFilter.methodsIn(element.getEnclosedElements()).stream().filter(method -> method.getSimpleName().toString().equals(buildMethodName)).findFirst().orElse(null);
        if (Objects.isNull(buildMethod)) {
            return Map.of();
        }
        DeclaredType buildMethodType = (DeclaredType)buildMethod.getReturnType();
        Element builderType = buildMethodType.asElement();
        return ElementUtils.findSetterForFields(builderType, fieldNames, buildMethodType, Modifier.PUBLIC).collect(ElementUtils.toLinkedMap(Map.Entry::getKey, entry -> ((ExecutableElement)((Optional)entry.getValue()).orElseThrow(() -> new FixtureCreationException("No valid setter could be found on %s to set %s".formatted(builderType, entry.getKey())))).getSimpleName().toString()));
    }

    private static String createReturnValueString(Element element, String className, String buildMethod, Collection<Constant> correspondingConstants) {
        Map<String, String> fieldToSetterMap = BuilderCreationMethodStrategy.getConstantToSetterMap(element, buildMethod, correspondingConstants);
        String setterString = correspondingConstants.stream().map(constant -> ".%s(%s)".formatted(fieldToSetterMap.containsKey(constant.getOriginalFieldName()) ? fieldToSetterMap.get(constant.getOriginalFieldName()) : constant.getOriginalFieldName(), constant.getName())).collect(Collectors.joining("\n%s".formatted(FormattingConstants.WHITESPACE_16)));
        return "%s.%s()\n%s%s".formatted(className, buildMethod, FormattingConstants.WHITESPACE_16, setterString);
    }
}

