/*
 * Decompiled with CFR 0.152.
 */
package de.floydkretschmar.fixturize.stategies.constants.value.providers.custom;

import de.floydkretschmar.fixturize.domain.TypeMetadata;
import de.floydkretschmar.fixturize.stategies.constants.value.providers.ValueProvider;
import java.util.Optional;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;

public class EnumValueProvider
implements ValueProvider {
    @Override
    public String provideValueAsString(Element field, TypeMetadata metadata) {
        TypeMirror fieldType = field.asType();
        Element declaredElement = ((DeclaredType)fieldType).asElement();
        Optional<String> firstEnumElement = declaredElement.getEnclosedElements().stream().filter(element -> element.getKind().equals((Object)ElementKind.ENUM_CONSTANT)).map(Object::toString).findFirst();
        if (firstEnumElement.isEmpty()) {
            return "null";
        }
        return "%s.%s".formatted(metadata.getQualifiedClassName(), firstEnumElement.get());
    }
}

