/*
 * Decompiled with CFR 0.152.
 */
package de.floydkretschmar.fixturize.stategies.constants.value.providers.custom;

import de.floydkretschmar.fixturize.domain.TypeMetadata;
import de.floydkretschmar.fixturize.stategies.constants.value.ValueProviderService;
import de.floydkretschmar.fixturize.stategies.constants.value.providers.ValueProvider;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;

public class ContainerValueProvider
implements ValueProvider {
    private final ValueProviderService valueProviderService;
    private final Types typeUtils;
    private final String wildcardValueString;

    @Override
    public String provideValueAsString(Element field, TypeMetadata metadata) {
        TypeMirror fieldType = field.asType();
        DeclaredType declaredType = (DeclaredType)fieldType;
        String parameterString = declaredType.getTypeArguments().stream().map(this.typeUtils::asElement).map(this.valueProviderService::getValueFor).collect(Collectors.joining(", "));
        return this.wildcardValueString.formatted(parameterString);
    }

    public ContainerValueProvider(ValueProviderService valueProviderService, Types typeUtils, String wildcardValueString) {
        this.valueProviderService = valueProviderService;
        this.typeUtils = typeUtils;
        this.wildcardValueString = wildcardValueString;
    }
}

