/*
 * Decompiled with CFR 0.152.
 */
package de.floydkretschmar.fixturize.stategies.constants.value.providers.custom;

import de.floydkretschmar.fixturize.ElementUtils;
import de.floydkretschmar.fixturize.annotations.FixtureBuilder;
import de.floydkretschmar.fixturize.annotations.FixtureConstructor;
import de.floydkretschmar.fixturize.domain.TypeMetadata;
import de.floydkretschmar.fixturize.domain.VariableElementMetadata;
import de.floydkretschmar.fixturize.stategies.constants.value.ValueProviderService;
import de.floydkretschmar.fixturize.stategies.constants.value.providers.ValueProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.util.ElementFilter;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.NoArgsConstructor;
import lombok.RequiredArgsConstructor;

public class ClassValueProvider
implements ValueProvider {
    private final ValueProviderService valueProviderService;

    @Override
    public String provideValueAsString(Element field, TypeMetadata metadata) {
        DeclaredType fieldType = (DeclaredType)field.asType();
        return this.provideDefaultFallbackValue(fieldType.asElement(), metadata, this.valueProviderService);
    }

    private String provideDefaultFallbackValue(Element declaredElement, TypeMetadata metadata, ValueProviderService valueProviderService) {
        String returnValue = this.provideBuilderCreationMethodAsValue(declaredElement, metadata);
        if (!returnValue.equals("null")) {
            return returnValue;
        }
        returnValue = this.provideConstructorCreationMethodAsValue(declaredElement, metadata);
        if (!returnValue.equals("null")) {
            return returnValue;
        }
        returnValue = this.provideLombokCreationMethodAsValue(declaredElement, metadata, valueProviderService);
        if (!returnValue.equals("null")) {
            return returnValue;
        }
        returnValue = this.providePublicConstructorAsValue(declaredElement, metadata, valueProviderService);
        if (!returnValue.equals("null")) {
            return returnValue;
        }
        returnValue = this.provideBuildMethodAsValue(declaredElement, metadata, valueProviderService);
        if (!returnValue.equals("null")) {
            return returnValue;
        }
        return returnValue;
    }

    private String provideLombokCreationMethodAsValue(Element declaredElement, TypeMetadata metadata, ValueProviderService valueProviderService) {
        List<VariableElementMetadata> fields = metadata.createVariableElementMetadata(ElementFilter.fieldsIn(declaredElement.getEnclosedElements()));
        String constructorName = ClassValueProvider.getConstructorName(metadata);
        if (Objects.nonNull(declaredElement.getAnnotation(Builder.class))) {
            return this.createBuilderValue(fields.stream().collect(ElementUtils.toLinkedMap(VariableElementMetadata::getName, data -> valueProviderService.getValueFor(data.getTypedElement()))), metadata.getQualifiedClassNameWithoutGeneric(), ClassValueProvider.getBuilderMethodName("builder", metadata), "build");
        }
        if (Objects.nonNull(declaredElement.getAnnotation(AllArgsConstructor.class))) {
            return this.createConstructorValue(constructorName, fields.stream().map(VariableElementMetadata::getTypedElement).toList(), valueProviderService);
        }
        if (Objects.nonNull(declaredElement.getAnnotation(RequiredArgsConstructor.class))) {
            List<Element> requiredFields = fields.stream().filter(field -> field.getModifiers().contains((Object)Modifier.FINAL) && Objects.isNull(field.getConstantValue())).map(VariableElementMetadata::getTypedElement).toList();
            return this.createConstructorValue(constructorName, requiredFields, valueProviderService);
        }
        if (Objects.nonNull(declaredElement.getAnnotation(NoArgsConstructor.class))) {
            return this.createConstructorValue(constructorName, new ArrayList(), valueProviderService);
        }
        return "null";
    }

    private String provideBuildMethodAsValue(Element declaredElement, TypeMetadata metadata, ValueProviderService valueProviderService) {
        String builderName = "%s.%sBuilder".formatted(metadata.getQualifiedClassNameWithoutGeneric(), metadata.getSimpleClassNameWithoutGeneric());
        ExecutableElement builderMethod = ElementUtils.findMethodWithModifiersByReturnType(declaredElement, builderName, Modifier.PUBLIC, Modifier.STATIC);
        if (Objects.isNull(builderMethod)) {
            return "null";
        }
        DeclaredType builderType = (DeclaredType)builderMethod.getReturnType();
        Element builderTypeElement = builderType.asElement();
        ExecutableElement buildMethod = ElementUtils.findMethodWithModifiersByReturnType(builderTypeElement, metadata.getQualifiedClassName(), Modifier.PUBLIC);
        if (Objects.isNull(buildMethod)) {
            return "null";
        }
        List<VariableElementMetadata> fields = metadata.createVariableElementMetadata(ElementFilter.fieldsIn(declaredElement.getEnclosedElements()));
        Map<String, String> builderSetter = ElementUtils.findSetterForFields(builderTypeElement, fields, builderType, Modifier.PUBLIC).filter(entry -> ((Optional)entry.getValue()).isPresent()).collect(ElementUtils.toLinkedMap(entry -> ((ExecutableElement)((Optional)entry.getValue()).orElseThrow()).getSimpleName().toString(), entry -> valueProviderService.getValueFor(((VariableElementMetadata)entry.getKey()).getTypedElement())));
        return this.createBuilderValue(builderSetter, metadata.getQualifiedClassNameWithoutGeneric(), ClassValueProvider.getBuilderMethodName(builderMethod.getSimpleName().toString(), metadata), buildMethod.getSimpleName().toString());
    }

    private String providePublicConstructorAsValue(Element declaredElement, TypeMetadata metadata, ValueProviderService valueProviderService) {
        ExecutableElement mostParametersConstructor = ElementFilter.constructorsIn(declaredElement.getEnclosedElements()).stream().filter(constructor -> constructor.getModifiers().contains((Object)Modifier.PUBLIC)).max(Comparator.comparing(constructor -> constructor.getParameters().size())).orElse(null);
        if (Objects.isNull(mostParametersConstructor)) {
            return "null";
        }
        List<Element> parameters = metadata.createVariableElementMetadata(mostParametersConstructor.getParameters()).stream().map(VariableElementMetadata::getTypedElement).toList();
        return this.createConstructorValue(ClassValueProvider.getConstructorName(metadata), parameters, valueProviderService);
    }

    private String provideBuilderCreationMethodAsValue(Element declaredElement, TypeMetadata metadata) {
        return Arrays.stream((FixtureBuilder[])declaredElement.getAnnotationsByType(FixtureBuilder.class)).max(Comparator.comparing(annotation -> annotation.usedSetters().length)).map(firstBuilder -> "%sFixture.%s().build()".formatted(metadata.getQualifiedClassNameWithoutGeneric(), firstBuilder.methodName())).orElse("null");
    }

    private String provideConstructorCreationMethodAsValue(Element declaredElement, TypeMetadata metadata) {
        return Arrays.stream((FixtureConstructor[])declaredElement.getAnnotationsByType(FixtureConstructor.class)).max(Comparator.comparing(annotation -> annotation.constructorParameters().length)).map(firstBuilder -> "%sFixture.%s()".formatted(metadata.getQualifiedClassNameWithoutGeneric(), firstBuilder.methodName())).orElse("null");
    }

    private String createBuilderValue(Map<String, String> setterAndValueMap, String className, String builderMethodName, String buildMethodName) {
        String setterString = setterAndValueMap.entrySet().stream().map(setterAndValue -> ".%s(%s)".formatted(setterAndValue.getKey(), setterAndValue.getValue())).collect(Collectors.joining());
        return "%s.%s()%s.%s()".formatted(className, builderMethodName, setterString, buildMethodName);
    }

    private String createConstructorValue(String className, List<? extends Element> parameterValues, ValueProviderService valueProviderService) {
        String recursiveParameterString = parameterValues.stream().map(valueProviderService::getValueFor).collect(Collectors.joining(", "));
        return "new %s(%s)".formatted(className, recursiveParameterString);
    }

    private static String getConstructorName(TypeMetadata metadata) {
        return "%s%s".formatted(metadata.getQualifiedClassNameWithoutGeneric(), metadata.isGeneric() ? "<>" : "");
    }

    private static String getBuilderMethodName(String builderMethodName, TypeMetadata metadata) {
        return "%s%s".formatted(metadata.getGenericPart(), builderMethodName);
    }

    public ClassValueProvider(ValueProviderService valueProviderService) {
        this.valueProviderService = valueProviderService;
    }
}

