/*
 * Decompiled with CFR 0.152.
 */
package de.floydkretschmar.fixturize.stategies.constants.value;

import de.floydkretschmar.fixturize.stategies.constants.value.ValueProviderService;
import de.floydkretschmar.fixturize.stategies.constants.value.providers.ValueProvider;
import de.floydkretschmar.fixturize.stategies.constants.value.providers.custom.BooleanValueProvider;
import de.floydkretschmar.fixturize.stategies.constants.value.providers.custom.ByteValueProvider;
import de.floydkretschmar.fixturize.stategies.constants.value.providers.custom.CharacterValueProvider;
import de.floydkretschmar.fixturize.stategies.constants.value.providers.custom.ContainerValueProvider;
import de.floydkretschmar.fixturize.stategies.constants.value.providers.custom.DoubleValueProvider;
import de.floydkretschmar.fixturize.stategies.constants.value.providers.custom.FloatValueProvider;
import de.floydkretschmar.fixturize.stategies.constants.value.providers.custom.IntegerValueProvider;
import de.floydkretschmar.fixturize.stategies.constants.value.providers.custom.LongValueProvider;
import de.floydkretschmar.fixturize.stategies.constants.value.providers.custom.ShortValueProvider;
import de.floydkretschmar.fixturize.stategies.constants.value.providers.custom.StringValueProvider;
import de.floydkretschmar.fixturize.stategies.constants.value.providers.custom.UUIDValueProvider;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import javax.lang.model.util.Types;

public class ValueProviderMap
extends HashMap<String, ValueProvider> {
    public ValueProviderMap(Map<? extends String, ? extends ValueProvider> customClassValueProviders, Types typeUtils, ValueProviderService valueProviderService) {
        super(customClassValueProviders);
        this.putIfAbsent(Boolean.TYPE.getName(), new BooleanValueProvider());
        this.putIfAbsent(Byte.TYPE.getName(), new ByteValueProvider());
        this.putIfAbsent(Character.TYPE.getName(), new CharacterValueProvider());
        this.putIfAbsent(Double.TYPE.getName(), new DoubleValueProvider());
        this.putIfAbsent(Float.TYPE.getName(), new FloatValueProvider());
        this.putIfAbsent(Integer.TYPE.getName(), new IntegerValueProvider());
        this.putIfAbsent(Long.TYPE.getName(), new LongValueProvider());
        this.putIfAbsent(Short.TYPE.getName(), new ShortValueProvider());
        this.putIfAbsent(String.class.getName(), new StringValueProvider());
        this.putIfAbsent(UUID.class.getName(), new UUIDValueProvider());
        this.putIfAbsent(Boolean.class.getName(), new BooleanValueProvider());
        this.putIfAbsent(Byte.class.getName(), new ByteValueProvider());
        this.putIfAbsent(Character.class.getName(), new CharacterValueProvider());
        this.putIfAbsent(Double.class.getName(), new DoubleValueProvider());
        this.putIfAbsent(Float.class.getName(), new FloatValueProvider());
        this.putIfAbsent(Integer.class.getName(), new IntegerValueProvider());
        this.putIfAbsent(Long.class.getName(), new LongValueProvider());
        this.putIfAbsent(Short.class.getName(), new ShortValueProvider());
        this.putIfAbsent(BigDecimal.class.getName(), (field, names) -> "java.math.BigDecimal.ZERO");
        this.putIfAbsent(BigInteger.class.getName(), (field, names) -> "java.math.BigInteger.ZERO");
        this.putIfAbsent(Instant.class.getName(), (field, names) -> "java.time.Instant.now()");
        this.putIfAbsent(Duration.class.getName(), (field, names) -> "java.time.Duration.ZERO");
        this.putIfAbsent(LocalDate.class.getName(), (field, names) -> "java.time.LocalDate.now()");
        this.putIfAbsent(LocalDateTime.class.getName(), (field, names) -> "java.time.LocalDateTime.now()");
        this.putIfAbsent(LocalTime.class.getName(), (field, names) -> "java.time.LocalTime.now()");
        this.putIfAbsent(Date.class.getName(), (field, names) -> "new java.util.Date()");
        this.putIfAbsent(Map.class.getName(), new ContainerValueProvider(valueProviderService, typeUtils, "java.util.Map.of(%s)"));
        this.putIfAbsent(List.class.getName(), new ContainerValueProvider(valueProviderService, typeUtils, "java.util.List.of(%s)"));
        this.putIfAbsent(Set.class.getName(), new ContainerValueProvider(valueProviderService, typeUtils, "java.util.Set.of(%s)"));
        this.putIfAbsent(Queue.class.getName(), new ContainerValueProvider(valueProviderService, typeUtils, "new java.util.PriorityQueue<>(java.util.List.of(%s))"));
        this.putIfAbsent(Collection.class.getName(), new ContainerValueProvider(valueProviderService, typeUtils, "java.util.List.of(%s)"));
    }
}

