/*
 * Decompiled with CFR 0.152.
 */
package de.floydkretschmar.fixturize.stategies.constants.value;

import de.floydkretschmar.fixturize.domain.TypeMetadata;
import de.floydkretschmar.fixturize.exceptions.FixtureCreationException;
import de.floydkretschmar.fixturize.stategies.constants.metadata.MetadataFactory;
import de.floydkretschmar.fixturize.stategies.constants.value.ValueProviderMap;
import de.floydkretschmar.fixturize.stategies.constants.value.ValueProviderService;
import de.floydkretschmar.fixturize.stategies.constants.value.providers.ValueProvider;
import de.floydkretschmar.fixturize.stategies.constants.value.providers.ValueProviderFactory;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

public class ConstantValueProviderService
implements ValueProviderService {
    public static final String DEFAULT_VALUE = "null";
    private final ValueProviderMap valueProviders;
    private final ValueProvider enumValueProvider;
    private final ValueProvider classValueProvider;
    private final ValueProvider arrayValueProvider;
    private final MetadataFactory metadataFactory;
    private final Elements elementUtils;

    public ConstantValueProviderService(Map<String, ValueProvider> customValueProviders, ValueProviderFactory valueProviderFactory, Elements elementUtils, Types typeUtils, MetadataFactory metadataFactory) {
        this.valueProviders = valueProviderFactory.createValueProviders(customValueProviders, typeUtils, this);
        this.classValueProvider = valueProviderFactory.createClassValueProvider(this);
        this.arrayValueProvider = valueProviderFactory.createArrayValueProvider();
        this.enumValueProvider = valueProviderFactory.createEnumValueProvider();
        this.metadataFactory = metadataFactory;
        this.elementUtils = elementUtils;
    }

    @Override
    public String getValueFor(Element element) {
        TypeMirror type = element.asType();
        TypeMetadata metadata = this.metadataFactory.createMetadataFrom(type);
        String value = DEFAULT_VALUE;
        if (this.valueProviders.containsKey(metadata.getQualifiedClassName())) {
            value = ((ValueProvider)this.valueProviders.get(metadata.getQualifiedClassName())).provideValueAsString(element, metadata);
        } else if (this.valueProviders.containsKey(metadata.getQualifiedClassNameWithoutGeneric())) {
            value = ((ValueProvider)this.valueProviders.get(metadata.getQualifiedClassNameWithoutGeneric())).provideValueAsString(element, metadata);
        } else if (type.getKind() == TypeKind.ARRAY) {
            value = this.arrayValueProvider.provideValueAsString(element, metadata);
        } else if (type.getKind() == TypeKind.DECLARED) {
            Element declaredElement = ((DeclaredType)type).asElement();
            ElementKind elementKind = declaredElement.getKind();
            if (elementKind == ElementKind.ENUM) {
                value = this.enumValueProvider.provideValueAsString(element, metadata);
            } else if (elementKind == ElementKind.CLASS) {
                value = this.classValueProvider.provideValueAsString(element, metadata);
            }
        }
        return this.resolveValuesForDefaultPlaceholders(value);
    }

    @Override
    public String resolveValuesForDefaultPlaceholders(String valueStringWithPlaceholders) {
        Pattern valuePattern = Pattern.compile("(?<defaultValueType>\\#\\{[^\\{\\}\\$]*\\})");
        Matcher regex = valuePattern.matcher(valueStringWithPlaceholders);
        ArrayList<String> values = new ArrayList<String>();
        String value = valueStringWithPlaceholders;
        while (regex.find()) {
            String defaultValueTypeNameWildcard = regex.group("defaultValueType");
            String defaultValueTypeName = defaultValueTypeNameWildcard.substring(2, defaultValueTypeNameWildcard.length() - 1);
            TypeElement element = this.elementUtils.getTypeElement(defaultValueTypeName);
            if (Objects.isNull(element)) {
                throw new FixtureCreationException("%s is not a valid type that can be used for default value generation".formatted(defaultValueTypeName));
            }
            values.add(this.getValueFor(element));
            value = value.replace(defaultValueTypeNameWildcard, "%s");
        }
        return value.formatted(values.toArray());
    }
}

