/*
 * Decompiled with CFR 0.152.
 */
package de.floydkretschmar.fixturize.stategies.constants.metadata;

import de.floydkretschmar.fixturize.ElementUtils;
import de.floydkretschmar.fixturize.domain.TypeMetadata;
import de.floydkretschmar.fixturize.exceptions.FixtureCreationException;
import de.floydkretschmar.fixturize.stategies.constants.metadata.MetadataFactory;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;

public class TypeMetadataFactory
implements MetadataFactory {
    private final Elements elementUtils;

    @Override
    public TypeMetadata createMetadataFrom(TypeMirror type) {
        List<Object> concreteTypesSetForGenerics = List.of();
        if (type.getKind() == TypeKind.DECLARED && !((DeclaredType)type).getTypeArguments().isEmpty()) {
            concreteTypesSetForGenerics = ((DeclaredType)type).getTypeArguments();
        }
        return TypeMetadataFactory.createMetadata(type.toString(), concreteTypesSetForGenerics, this.elementUtils);
    }

    @Override
    public TypeMetadata createMetadataFrom(TypeMirror type, List<String> genericTypeImplementations) {
        List<TypeMirror> concreteTypesSetForGenerics = genericTypeImplementations.stream().map(typeString -> {
            TypeElement typeElement = this.elementUtils.getTypeElement((CharSequence)typeString);
            if (Objects.isNull(typeElement)) {
                throw new FixtureCreationException("The type %s defined for class %s does not exist".formatted(typeString, type.toString()));
            }
            return typeElement.asType();
        }).toList();
        return TypeMetadataFactory.createMetadata(type.toString(), concreteTypesSetForGenerics, this.elementUtils);
    }

    private static Map<? extends TypeMirror, ? extends DeclaredType> createGenericMap(List<? extends TypeMirror> concreteTypesSetForGenerics, String qualifiedClassNameWithoutGeneric, Elements elementUtils) {
        TypeElement fieldElementWithoutGenericsSet = elementUtils.getTypeElement(qualifiedClassNameWithoutGeneric);
        List<? extends TypeMirror> genericsDefinedOnType = ((DeclaredType)fieldElementWithoutGenericsSet.asType()).getTypeArguments();
        if (genericsDefinedOnType.size() != concreteTypesSetForGenerics.size()) {
            throw new FixtureCreationException("There is a mismatch in the number of defined generics and actual concrete types defined for these generics for class %s".formatted(qualifiedClassNameWithoutGeneric));
        }
        return genericsDefinedOnType.stream().collect(ElementUtils.toLinkedMap(Function.identity(), value -> (DeclaredType)concreteTypesSetForGenerics.get(genericsDefinedOnType.indexOf(value))));
    }

    private static TypeMetadata createMetadata(String qualifiedClassName, List<? extends TypeMirror> concreteTypesForGenerics, Elements elementUtils) {
        int genericStartIndex = qualifiedClassName.indexOf(60);
        String qualifiedClassNameWithoutGeneric = genericStartIndex > 0 ? qualifiedClassName.substring(0, genericStartIndex) : qualifiedClassName;
        int lastDot = qualifiedClassNameWithoutGeneric.lastIndexOf(46);
        String packageName = "";
        if (lastDot > 0) {
            packageName = qualifiedClassNameWithoutGeneric.substring(0, lastDot);
        }
        String simpleClassNameWithoutGeneric = qualifiedClassNameWithoutGeneric.substring(lastDot + 1);
        String qualifiedFixtureClassName = qualifiedClassNameWithoutGeneric + "Fixture";
        TypeMetadata.TypeMetadataBuilder builder = TypeMetadata.builder().packageName(packageName).qualifiedClassNameWithoutGeneric(qualifiedClassNameWithoutGeneric).simpleClassNameWithoutGeneric(simpleClassNameWithoutGeneric).qualifiedFixtureClassName(qualifiedFixtureClassName);
        TypeMetadataFactory.setGenericPart(builder, concreteTypesForGenerics, elementUtils, genericStartIndex, simpleClassNameWithoutGeneric, qualifiedClassNameWithoutGeneric);
        return builder.build();
    }

    private static void setGenericPart(TypeMetadata.TypeMetadataBuilder builder, List<? extends TypeMirror> concreteTypesForGenerics, Elements elementUtils, int genericStartIndex, String simpleClassNameWithoutGeneric, String qualifiedClassNameWithoutGeneric) {
        if (genericStartIndex > 0) {
            String genericPart = "<%s>".formatted(concreteTypesForGenerics.stream().map(TypeMirror::toString).collect(Collectors.joining(", ")));
            builder.genericPart(genericPart).simpleClassName("%s%s".formatted(simpleClassNameWithoutGeneric, genericPart)).qualifiedClassName("%s%s".formatted(qualifiedClassNameWithoutGeneric, genericPart)).genericTypeMap(TypeMetadataFactory.createGenericMap(concreteTypesForGenerics, qualifiedClassNameWithoutGeneric, elementUtils));
        } else {
            builder.genericPart("").simpleClassName(simpleClassNameWithoutGeneric).qualifiedClassName(qualifiedClassNameWithoutGeneric).genericTypeMap(Map.of());
        }
    }

    public TypeMetadataFactory(Elements elementUtils) {
        this.elementUtils = elementUtils;
    }
}

