/*
 * Decompiled with CFR 0.152.
 */
package de.floydkretschmar.fixturize.stategies.constants;

import de.floydkretschmar.fixturize.ElementUtils;
import de.floydkretschmar.fixturize.annotations.FixtureConstant;
import de.floydkretschmar.fixturize.domain.Constant;
import de.floydkretschmar.fixturize.domain.TypeMetadata;
import de.floydkretschmar.fixturize.domain.VariableElementMetadata;
import de.floydkretschmar.fixturize.stategies.constants.ConstantDefinitionMap;
import de.floydkretschmar.fixturize.stategies.constants.ConstantsNamingStrategy;
import de.floydkretschmar.fixturize.stategies.constants.FixtureConstantDefinitionMap;
import de.floydkretschmar.fixturize.stategies.constants.value.ValueProviderService;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;

public class ConstantGenerationStrategy {
    private final ConstantsNamingStrategy constantsNamingStrategy;
    private final ValueProviderService valueProviderService;

    public ConstantDefinitionMap generateConstants(TypeElement element, TypeMetadata metadata) {
        List<VariableElementMetadata> fields = metadata.createVariableElementMetadata(ElementFilter.fieldsIn(element.getEnclosedElements()));
        Map<String, Constant> linkedHashMap = this.createConstantsForFields(fields.stream()).collect(ElementUtils.toLinkedMap(Map.Entry::getKey, Map.Entry::getValue));
        return new FixtureConstantDefinitionMap((Map<? extends String, ? extends Constant>)linkedHashMap);
    }

    private Stream<Map.Entry<String, Constant>> createConstantsForFields(Stream<VariableElementMetadata> fields) {
        return fields.flatMap(field -> {
            FixtureConstant[] constantsAnnotations = (FixtureConstant[])field.getAnnotationsByType(FixtureConstant.class);
            if (constantsAnnotations.length == 0) {
                Constant constantDefinition = this.createConstant((VariableElementMetadata)field);
                String key = field.getName();
                return Stream.of(Map.entry(key, constantDefinition));
            }
            return Arrays.stream(constantsAnnotations).map(constantAnnotation -> {
                Constant constantDefinition = this.createConstant((FixtureConstant)constantAnnotation, (VariableElementMetadata)field);
                return Map.entry(constantDefinition.getName(), constantDefinition);
            });
        });
    }

    private Constant createConstant(FixtureConstant constantAnnotation, VariableElementMetadata field) {
        return Constant.builder().type(field.getTypedElement().asType().toString()).name(constantAnnotation.name()).value(this.getValue(constantAnnotation, field)).originalFieldName(field.getName()).build();
    }

    private String getValue(FixtureConstant constantAnnotation, VariableElementMetadata field) {
        if (!constantAnnotation.value().isEmpty()) {
            return this.valueProviderService.resolveValuesForDefaultPlaceholders(constantAnnotation.value());
        }
        return this.valueProviderService.getValueFor(field.getTypedElement());
    }

    private Constant createConstant(VariableElementMetadata field) {
        String originalFieldName = field.getName();
        return Constant.builder().type(field.getTypedElement().asType().toString()).name(this.constantsNamingStrategy.createConstantName(originalFieldName)).value(this.valueProviderService.getValueFor(field.getTypedElement())).originalFieldName(originalFieldName).build();
    }

    public ConstantGenerationStrategy(ConstantsNamingStrategy constantsNamingStrategy, ValueProviderService valueProviderService) {
        this.constantsNamingStrategy = constantsNamingStrategy;
        this.valueProviderService = valueProviderService;
    }
}

