/*
 * Decompiled with CFR 0.152.
 */
package de.floydkretschmar.fixturize.domain;

import de.floydkretschmar.fixturize.domain.VariableElementMetadata;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;

public final class TypeMetadata {
    private final String qualifiedClassName;
    private final String qualifiedClassNameWithoutGeneric;
    private final String simpleClassName;
    private final String simpleClassNameWithoutGeneric;
    private final String packageName;
    private final String qualifiedFixtureClassName;
    private final String genericPart;
    private final Map<? extends TypeMirror, ? extends DeclaredType> genericTypeMap;

    public boolean hasPackageName() {
        return !this.getPackageName().isEmpty();
    }

    public boolean isGeneric() {
        return !this.genericPart.isEmpty();
    }

    public List<VariableElementMetadata> createVariableElementMetadata(List<? extends VariableElement> elements) {
        return elements.stream().map(field -> {
            Element returnValue = field;
            if (this.getGenericTypeMap().containsKey(field.asType())) {
                returnValue = this.getGenericTypeMap().get(field.asType()).asElement();
            }
            return VariableElementMetadata.builder().variableElement((VariableElement)field).typedElement(returnValue).build();
        }).toList();
    }

    TypeMetadata(String qualifiedClassName, String qualifiedClassNameWithoutGeneric, String simpleClassName, String simpleClassNameWithoutGeneric, String packageName, String qualifiedFixtureClassName, String genericPart, Map<? extends TypeMirror, ? extends DeclaredType> genericTypeMap) {
        this.qualifiedClassName = qualifiedClassName;
        this.qualifiedClassNameWithoutGeneric = qualifiedClassNameWithoutGeneric;
        this.simpleClassName = simpleClassName;
        this.simpleClassNameWithoutGeneric = simpleClassNameWithoutGeneric;
        this.packageName = packageName;
        this.qualifiedFixtureClassName = qualifiedFixtureClassName;
        this.genericPart = genericPart;
        this.genericTypeMap = genericTypeMap;
    }

    public static TypeMetadataBuilder builder() {
        return new TypeMetadataBuilder();
    }

    public String getQualifiedClassName() {
        return this.qualifiedClassName;
    }

    public String getQualifiedClassNameWithoutGeneric() {
        return this.qualifiedClassNameWithoutGeneric;
    }

    public String getSimpleClassName() {
        return this.simpleClassName;
    }

    public String getSimpleClassNameWithoutGeneric() {
        return this.simpleClassNameWithoutGeneric;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getQualifiedFixtureClassName() {
        return this.qualifiedFixtureClassName;
    }

    public String getGenericPart() {
        return this.genericPart;
    }

    public Map<? extends TypeMirror, ? extends DeclaredType> getGenericTypeMap() {
        return this.genericTypeMap;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TypeMetadata)) {
            return false;
        }
        TypeMetadata other = (TypeMetadata)o;
        String this$qualifiedClassName = this.getQualifiedClassName();
        String other$qualifiedClassName = other.getQualifiedClassName();
        if (this$qualifiedClassName == null ? other$qualifiedClassName != null : !this$qualifiedClassName.equals(other$qualifiedClassName)) {
            return false;
        }
        String this$qualifiedClassNameWithoutGeneric = this.getQualifiedClassNameWithoutGeneric();
        String other$qualifiedClassNameWithoutGeneric = other.getQualifiedClassNameWithoutGeneric();
        if (this$qualifiedClassNameWithoutGeneric == null ? other$qualifiedClassNameWithoutGeneric != null : !this$qualifiedClassNameWithoutGeneric.equals(other$qualifiedClassNameWithoutGeneric)) {
            return false;
        }
        String this$simpleClassName = this.getSimpleClassName();
        String other$simpleClassName = other.getSimpleClassName();
        if (this$simpleClassName == null ? other$simpleClassName != null : !this$simpleClassName.equals(other$simpleClassName)) {
            return false;
        }
        String this$simpleClassNameWithoutGeneric = this.getSimpleClassNameWithoutGeneric();
        String other$simpleClassNameWithoutGeneric = other.getSimpleClassNameWithoutGeneric();
        if (this$simpleClassNameWithoutGeneric == null ? other$simpleClassNameWithoutGeneric != null : !this$simpleClassNameWithoutGeneric.equals(other$simpleClassNameWithoutGeneric)) {
            return false;
        }
        String this$packageName = this.getPackageName();
        String other$packageName = other.getPackageName();
        if (this$packageName == null ? other$packageName != null : !this$packageName.equals(other$packageName)) {
            return false;
        }
        String this$qualifiedFixtureClassName = this.getQualifiedFixtureClassName();
        String other$qualifiedFixtureClassName = other.getQualifiedFixtureClassName();
        if (this$qualifiedFixtureClassName == null ? other$qualifiedFixtureClassName != null : !this$qualifiedFixtureClassName.equals(other$qualifiedFixtureClassName)) {
            return false;
        }
        String this$genericPart = this.getGenericPart();
        String other$genericPart = other.getGenericPart();
        if (this$genericPart == null ? other$genericPart != null : !this$genericPart.equals(other$genericPart)) {
            return false;
        }
        Map<? extends TypeMirror, ? extends DeclaredType> this$genericTypeMap = this.getGenericTypeMap();
        Map<? extends TypeMirror, ? extends DeclaredType> other$genericTypeMap = other.getGenericTypeMap();
        return !(this$genericTypeMap == null ? other$genericTypeMap != null : !((Object)this$genericTypeMap).equals(other$genericTypeMap));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $qualifiedClassName = this.getQualifiedClassName();
        result = result * 59 + ($qualifiedClassName == null ? 43 : $qualifiedClassName.hashCode());
        String $qualifiedClassNameWithoutGeneric = this.getQualifiedClassNameWithoutGeneric();
        result = result * 59 + ($qualifiedClassNameWithoutGeneric == null ? 43 : $qualifiedClassNameWithoutGeneric.hashCode());
        String $simpleClassName = this.getSimpleClassName();
        result = result * 59 + ($simpleClassName == null ? 43 : $simpleClassName.hashCode());
        String $simpleClassNameWithoutGeneric = this.getSimpleClassNameWithoutGeneric();
        result = result * 59 + ($simpleClassNameWithoutGeneric == null ? 43 : $simpleClassNameWithoutGeneric.hashCode());
        String $packageName = this.getPackageName();
        result = result * 59 + ($packageName == null ? 43 : $packageName.hashCode());
        String $qualifiedFixtureClassName = this.getQualifiedFixtureClassName();
        result = result * 59 + ($qualifiedFixtureClassName == null ? 43 : $qualifiedFixtureClassName.hashCode());
        String $genericPart = this.getGenericPart();
        result = result * 59 + ($genericPart == null ? 43 : $genericPart.hashCode());
        Map<? extends TypeMirror, ? extends DeclaredType> $genericTypeMap = this.getGenericTypeMap();
        result = result * 59 + ($genericTypeMap == null ? 43 : ((Object)$genericTypeMap).hashCode());
        return result;
    }

    public String toString() {
        return "TypeMetadata(qualifiedClassName=" + this.getQualifiedClassName() + ", qualifiedClassNameWithoutGeneric=" + this.getQualifiedClassNameWithoutGeneric() + ", simpleClassName=" + this.getSimpleClassName() + ", simpleClassNameWithoutGeneric=" + this.getSimpleClassNameWithoutGeneric() + ", packageName=" + this.getPackageName() + ", qualifiedFixtureClassName=" + this.getQualifiedFixtureClassName() + ", genericPart=" + this.getGenericPart() + ", genericTypeMap=" + String.valueOf(this.getGenericTypeMap()) + ")";
    }

    public static class TypeMetadataBuilder {
        private String qualifiedClassName;
        private String qualifiedClassNameWithoutGeneric;
        private String simpleClassName;
        private String simpleClassNameWithoutGeneric;
        private String packageName;
        private String qualifiedFixtureClassName;
        private String genericPart;
        private Map<? extends TypeMirror, ? extends DeclaredType> genericTypeMap;

        TypeMetadataBuilder() {
        }

        public TypeMetadataBuilder qualifiedClassName(String qualifiedClassName) {
            this.qualifiedClassName = qualifiedClassName;
            return this;
        }

        public TypeMetadataBuilder qualifiedClassNameWithoutGeneric(String qualifiedClassNameWithoutGeneric) {
            this.qualifiedClassNameWithoutGeneric = qualifiedClassNameWithoutGeneric;
            return this;
        }

        public TypeMetadataBuilder simpleClassName(String simpleClassName) {
            this.simpleClassName = simpleClassName;
            return this;
        }

        public TypeMetadataBuilder simpleClassNameWithoutGeneric(String simpleClassNameWithoutGeneric) {
            this.simpleClassNameWithoutGeneric = simpleClassNameWithoutGeneric;
            return this;
        }

        public TypeMetadataBuilder packageName(String packageName) {
            this.packageName = packageName;
            return this;
        }

        public TypeMetadataBuilder qualifiedFixtureClassName(String qualifiedFixtureClassName) {
            this.qualifiedFixtureClassName = qualifiedFixtureClassName;
            return this;
        }

        public TypeMetadataBuilder genericPart(String genericPart) {
            this.genericPart = genericPart;
            return this;
        }

        public TypeMetadataBuilder genericTypeMap(Map<? extends TypeMirror, ? extends DeclaredType> genericTypeMap) {
            this.genericTypeMap = genericTypeMap;
            return this;
        }

        public TypeMetadata build() {
            return new TypeMetadata(this.qualifiedClassName, this.qualifiedClassNameWithoutGeneric, this.simpleClassName, this.simpleClassNameWithoutGeneric, this.packageName, this.qualifiedFixtureClassName, this.genericPart, this.genericTypeMap);
        }

        public String toString() {
            return "TypeMetadata.TypeMetadataBuilder(qualifiedClassName=" + this.qualifiedClassName + ", qualifiedClassNameWithoutGeneric=" + this.qualifiedClassNameWithoutGeneric + ", simpleClassName=" + this.simpleClassName + ", simpleClassNameWithoutGeneric=" + this.simpleClassNameWithoutGeneric + ", packageName=" + this.packageName + ", qualifiedFixtureClassName=" + this.qualifiedFixtureClassName + ", genericPart=" + this.genericPart + ", genericTypeMap=" + String.valueOf(this.genericTypeMap) + ")";
        }
    }
}

