/*
 * Decompiled with CFR 0.152.
 */
package de.floydkretschmar.fixturize;

import com.google.auto.service.AutoService;
import de.floydkretschmar.fixturize.CustomValueProviderParser;
import de.floydkretschmar.fixturize.FormattingConstants;
import de.floydkretschmar.fixturize.annotations.Fixture;
import de.floydkretschmar.fixturize.annotations.FixtureValueProvider;
import de.floydkretschmar.fixturize.domain.Constant;
import de.floydkretschmar.fixturize.domain.TypeMetadata;
import de.floydkretschmar.fixturize.exceptions.FixtureCreationException;
import de.floydkretschmar.fixturize.stategies.constants.CamelCaseToScreamingSnakeCaseNamingStrategy;
import de.floydkretschmar.fixturize.stategies.constants.ConstantDefinitionMap;
import de.floydkretschmar.fixturize.stategies.constants.ConstantGenerationStrategy;
import de.floydkretschmar.fixturize.stategies.constants.metadata.MetadataFactory;
import de.floydkretschmar.fixturize.stategies.constants.metadata.TypeMetadataFactory;
import de.floydkretschmar.fixturize.stategies.constants.value.ConstantValueProviderService;
import de.floydkretschmar.fixturize.stategies.constants.value.providers.DefaultValueProviderFactory;
import de.floydkretschmar.fixturize.stategies.constants.value.providers.ValueProvider;
import de.floydkretschmar.fixturize.stategies.creation.BuilderCreationMethodStrategy;
import de.floydkretschmar.fixturize.stategies.creation.ConstructorCreationMethodStrategy;
import de.floydkretschmar.fixturize.stategies.creation.CreationMethodGenerationStrategy;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.JavaFileObject;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.HostAccess;

@SupportedAnnotationTypes(value={"de.floydkretschmar.fixturize.annotations.Fixture"})
@AutoService(value={Processor.class})
public class FixtureProcessor
extends AbstractProcessor {
    private Types typeUtils;
    private Elements elementUtils;
    private CustomValueProviderParser valueProviderParser;

    @Override
    public SourceVersion getSupportedSourceVersion() {
        if (SourceVersion.RELEASE_17.compareTo(SourceVersion.latest()) > 0) {
            return SourceVersion.RELEASE_17;
        }
        return SourceVersion.latest();
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.typeUtils = processingEnv.getTypeUtils();
        this.elementUtils = processingEnv.getElementUtils();
        this.valueProviderParser = new CustomValueProviderParser(Context.newBuilder((String[])new String[]{"js"}).allowHostAccess(HostAccess.ALL).build());
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        for (TypeElement typeElement : annotations) {
            for (Element element : roundEnv.getElementsAnnotatedWith(typeElement)) {
                this.processAnnotatedElement((TypeElement)element);
            }
        }
        return true;
    }

    private void processAnnotatedElement(TypeElement element) {
        TypeMetadataFactory metadataFactory = new TypeMetadataFactory(this.elementUtils);
        ConstantValueProviderService valueProviderService = this.initializeValueProviderService((FixtureValueProvider[])element.getAnnotationsByType(FixtureValueProvider.class), metadataFactory);
        CamelCaseToScreamingSnakeCaseNamingStrategy constantsNamingStrategy = new CamelCaseToScreamingSnakeCaseNamingStrategy();
        ConstantGenerationStrategy constantsGenerationStrategy = new ConstantGenerationStrategy(constantsNamingStrategy, valueProviderService);
        ArrayList<CreationMethodGenerationStrategy> creationMethodStrategies = new ArrayList<CreationMethodGenerationStrategy>();
        creationMethodStrategies.add(new ConstructorCreationMethodStrategy());
        creationMethodStrategies.add(new BuilderCreationMethodStrategy());
        Fixture fixtureAnnotation = element.getAnnotation(Fixture.class);
        TypeMetadata metadata = metadataFactory.createMetadataFrom(element.asType(), Arrays.stream(fixtureAnnotation.genericImplementations()).toList());
        try {
            JavaFileObject fixtureFile = this.processingEnv.getFiler().createSourceFile(metadata.getQualifiedFixtureClassName(), new Element[0]);
            try (PrintWriter out = new PrintWriter(fixtureFile.openWriter());){
                String fixtureClassString = FixtureProcessor.getFixtureClassAsString(element, metadata, constantsGenerationStrategy, creationMethodStrategies);
                out.print(fixtureClassString);
            }
        }
        catch (IOException e) {
            throw new FixtureCreationException("Failed to create source file %s for fixture.".formatted(metadata.getQualifiedClassName()));
        }
    }

    private ConstantValueProviderService initializeValueProviderService(FixtureValueProvider[] customFixtureProviders, MetadataFactory metadataFactory) {
        Map<String, ValueProvider> customValueProviders = Arrays.stream(customFixtureProviders).collect(Collectors.toMap(FixtureValueProvider::targetType, annotation -> this.valueProviderParser.parseValueProvider(annotation.valueProviderCallback())));
        return new ConstantValueProviderService(customValueProviders, new DefaultValueProviderFactory(), this.elementUtils, this.typeUtils, metadataFactory);
    }

    private static String getCreationMethodsString(TypeElement element, List<CreationMethodGenerationStrategy> creationMethodStrategies, ConstantDefinitionMap constantMap, TypeMetadata metadata) {
        return creationMethodStrategies.stream().flatMap(stategy -> stategy.generateCreationMethods(element, constantMap, metadata).stream()).map(method -> "%spublic static %s %s() {\n%sreturn %s;\n%s}".formatted(FormattingConstants.WHITESPACE_4, method.getReturnType(), method.getName(), FormattingConstants.WHITESPACE_8, method.getReturnValue(), FormattingConstants.WHITESPACE_4)).collect(Collectors.joining("\n\n"));
    }

    private static String getConstantsString(Stream<Constant> constants) {
        return constants.map(constant -> "%spublic static %s %s = %s;".formatted(FormattingConstants.WHITESPACE_4, constant.getType(), constant.getName(), constant.getValue())).collect(Collectors.joining("\n"));
    }

    private static String getFixtureClassAsString(TypeElement element, TypeMetadata metadata, ConstantGenerationStrategy constantsGenerationStrategy, ArrayList<CreationMethodGenerationStrategy> creationMethodStrategies) {
        String fixtureClassTemplate = "%spublic class %sFixture {\n%s\n\n%s\n}\n";
        String packageString = metadata.hasPackageName() ? "package %s;\n\n".formatted(metadata.getPackageName()) : "";
        ConstantDefinitionMap constantMap = constantsGenerationStrategy.generateConstants(element, metadata);
        String constantsString = FixtureProcessor.getConstantsString(constantMap.values().stream());
        String creationMethodsString = FixtureProcessor.getCreationMethodsString(element, creationMethodStrategies, constantMap, metadata);
        return String.format("%spublic class %sFixture {\n%s\n\n%s\n}\n", packageString, metadata.getSimpleClassNameWithoutGeneric(), constantsString, creationMethodsString);
    }
}

