/*
 * Decompiled with CFR 0.152.
 */
package de.floydkretschmar.fixturize;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;

public class ElementUtils {
    public static ExecutableElement findMethodWithModifiersByReturnType(Element element, String returnTypeName, Modifier ... modifiers) {
        return ElementFilter.methodsIn(element.getEnclosedElements()).stream().filter(method -> Arrays.stream(modifiers).allMatch(modifier -> method.getModifiers().contains(modifier)) && method.getReturnType().toString().equals(returnTypeName)).findFirst().orElse(null);
    }

    public static <T> Stream<Map.Entry<T, Optional<ExecutableElement>>> findSetterForFields(Element element, List<T> fields, TypeMirror returnType, Modifier ... modifiers) {
        return fields.stream().map(field -> Map.entry(field, ElementFilter.methodsIn(element.getEnclosedElements()).stream().filter(method -> Arrays.stream(modifiers).allMatch(modifier -> method.getModifiers().contains(modifier)) && method.getSimpleName().toString().toLowerCase().matches("[set]*" + field.toString().toLowerCase()) && method.getReturnType().equals(returnType) && method.getParameters().size() == 1).findFirst()));
    }

    public static <T, K, U> Collector<T, ?, Map<K, U>> toLinkedMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper) {
        return Collectors.toMap(keyMapper, valueMapper, (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", u));
        }, LinkedHashMap::new);
    }
}

