/*
 * Decompiled with CFR 0.152.
 */
package de.floydkretschmar.autofixture;

import de.floydkretschmar.autofixture.exceptions.ConfigurationReadException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;

final class ConfigurationLoader {
    private static final Pattern includePattern = Pattern.compile("^(?<whitespaces> *)((?<listPrefix>- )|(?<objectPrefix>(.*: )))!include (?<fileName>.*\\.ya?ml)");

    ConfigurationLoader() {
    }

    public static String readConfiguration(String configurationFile) {
        return ConfigurationLoader.readConfigurationAsList(configurationFile).reduce("", (base, latest) -> base.isBlank() ? latest : "%s\r\n%s".formatted(base, latest));
    }

    private static Stream<String> readConfigurationAsList(String configurationFile) {
        URL configurationFileUrl = ConfigurationLoader.class.getClassLoader().getResource(configurationFile);
        if (configurationFileUrl == null) {
            throw new ConfigurationReadException(configurationFile);
        }
        try {
            List<String> linesOfOriginalConfiguration = Files.readAllLines(Path.of(configurationFileUrl.toURI()));
            return linesOfOriginalConfiguration.stream().flatMap(line -> {
                Matcher matcher = includePattern.matcher((CharSequence)line);
                return matcher.find() ? ConfigurationLoader.loadAndProcessSubConfiguration(matcher) : Stream.of(line);
            });
        }
        catch (IOException | IllegalArgumentException | OutOfMemoryError | SecurityException | URISyntaxException | FileSystemNotFoundException e) {
            throw new ConfigurationReadException(configurationFile, e);
        }
    }

    private static Stream<String> loadAndProcessSubConfiguration(Matcher matcher) {
        String includedFileName = matcher.group("fileName");
        Stream<String> linesOfIncludedConfiguration = ConfigurationLoader.readConfigurationAsList(includedFileName);
        if (Objects.nonNull(matcher.group("objectPrefix"))) {
            int whitespacesBeforeObjectName = matcher.group("whitespaces").length();
            return Stream.concat(Stream.of("%s%s".formatted(" ".repeat(whitespacesBeforeObjectName), matcher.group("objectPrefix").stripTrailing())), linesOfIncludedConfiguration.map(includedConfigurationLine -> "%s%s".formatted(" ".repeat(whitespacesBeforeObjectName + 2), includedConfigurationLine)));
        }
        int whitespacesBeforeHyphen = matcher.group("whitespaces").length();
        int whitespacesBeforeItemContent = whitespacesBeforeHyphen + 2;
        List<String> linesAsList = linesOfIncludedConfiguration.toList();
        return Stream.concat(Stream.of("%s- %s".formatted(" ".repeat(whitespacesBeforeHyphen), linesAsList.get(0))), linesAsList.stream().skip(1L).map(includedConfigurationLine -> "%s%s".formatted(" ".repeat(whitespacesBeforeItemContent), includedConfigurationLine)));
    }
}

