/*
 * Decompiled with CFR 0.152.
 */
package de.floydkretschmar.autofixture;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import de.floydkretschmar.autofixture.Autofixture;
import de.floydkretschmar.autofixture.ConfigurationLoader;
import de.floydkretschmar.autofixture.FieldHelper;
import de.floydkretschmar.autofixture.exceptions.FixtureCreationException;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestInstancePostProcessor;

public class AutofixtureExtension
implements TestInstancePostProcessor {
    private final ObjectMapper objectMapper = new ObjectMapper((JsonFactory)new YAMLFactory());

    public AutofixtureExtension() {
        this.objectMapper.findAndRegisterModules();
    }

    public void postProcessTestInstance(Object testInstance, ExtensionContext extensionContext) {
        List<Field> declaredFixtureFields = Arrays.stream(testInstance.getClass().getDeclaredFields()).filter(field -> field.isAnnotationPresent(Autofixture.class)).toList();
        for (Field fixtureField : declaredFixtureFields) {
            Object fixture;
            Class<?> fixtureType = fixtureField.getType();
            String configurationFilename = AutofixtureExtension.getConfigurationFilename(fixtureField, fixtureType);
            String fixtureConfiguration = ConfigurationLoader.readConfiguration(configurationFilename);
            try {
                fixture = this.objectMapper.readValue(fixtureConfiguration, fixtureType);
            }
            catch (JsonProcessingException e) {
                throw new FixtureCreationException("Could not create autofixture for field %s because configuration file %s could not be parsed.".formatted(fixtureField.getName(), configurationFilename), e);
            }
            try {
                FieldHelper.setField(fixtureField, testInstance, fixture);
            }
            catch (Exception e) {
                throw new FixtureCreationException("Could not create autofixture for field %s because the instance of autofixture could not be assigned to the field.", e);
            }
        }
    }

    private static String getConfigurationFilename(Field fixtureField, Class<?> fixtureType) {
        Autofixture autofixtureAnnotation = fixtureField.getAnnotation(Autofixture.class);
        String configurationFile = autofixtureAnnotation.configurationResourcePath();
        if (configurationFile.isEmpty()) {
            Object className = fixtureType.getSimpleName();
            className = ((String)className).substring(0, 1).toLowerCase() + ((String)className).substring(1);
            configurationFile = "%s.yaml".formatted(className);
        }
        return configurationFile;
    }
}

