/*
 * Decompiled with CFR 0.152.
 */
package de.florianmichael.rclasses.pattern.evicting;

import java.util.Collections;
import java.util.List;

public class EvictingList<V> {
    private final List<V> list;
    private final int maxSize;

    public EvictingList() {
        this(Collections.emptyList(), 0);
    }

    public EvictingList(List<V> list, int maxSize) {
        this.list = list;
        this.maxSize = maxSize;
    }

    public boolean add(V value) {
        boolean full;
        boolean bl = full = this.list.size() >= this.maxSize;
        if (full) {
            this.list.remove(this.list.get(0));
        }
        this.list.add(value);
        return full;
    }

    public boolean isFull() {
        return this.list.size() >= this.maxSize;
    }

    public List<V> getNormalList() {
        return this.list;
    }

    public int getMaxSize() {
        return this.maxSize;
    }
}

