/*
 * Decompiled with CFR 0.152.
 */
package de.florianmichael.rclasses.pattern.storage.named;

import de.florianmichael.rclasses.pattern.functional.IName;
import de.florianmichael.rclasses.pattern.storage.named.NamedStorage;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Supplier;

public abstract class SelectableNamedStorage<T extends IName>
extends NamedStorage<T>
implements IName {
    private T current;

    public SelectableNamedStorage() {
        this(CopyOnWriteArrayList::new);
    }

    public SelectableNamedStorage(Supplier<List<T>> list) {
        super(list);
    }

    public abstract T getDefault();

    public T getCurrent() {
        if (this.current == null) {
            this.setCurrent(this.getDefault());
        }
        return this.current;
    }

    public void setCurrent(T current) {
        this.current = current;
    }

    public void setCurrentByName(String name) {
        this.setCurrent(this.getList().stream().filter(t -> t.getName().equals(name)).findFirst().orElse(null));
    }
}

