/*
 * Decompiled with CFR 0.152.
 */
package de.florianmichael.rclasses.pattern.evicting;

import java.util.Collections;
import java.util.Map;

public final class EvictingMap<K, V> {
    private final Map<K, V> map;
    private final int maxSize;

    public EvictingMap() {
        this(Collections.emptyMap(), 0);
    }

    public EvictingMap(Map<K, V> map, int maxSize) {
        this.map = map;
        this.maxSize = maxSize;
    }

    public boolean put(K key, V value) {
        boolean full;
        boolean bl = full = this.map.size() >= this.maxSize;
        if (full) {
            this.map.remove(this.map.keySet().toArray()[0]);
        }
        this.map.put(key, value);
        return full;
    }

    public boolean isFull() {
        return this.map.size() >= this.maxSize;
    }

    public Map<K, V> getNormalMap() {
        return this.map;
    }

    public int getMaxSize() {
        return this.maxSize;
    }
}

