/*
 * Decompiled with CFR 0.152.
 */
package de.florianmichael.rclasses.pattern.storage;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.function.Supplier;

public abstract class Storage<T> {
    private final List<T> list;
    private Consumer<T> addConsumer;
    private Consumer<T> removeConsumer;

    public Storage() {
        this(CopyOnWriteArrayList::new);
    }

    public Storage(Supplier<List<T>> list) {
        this.list = list.get();
    }

    public abstract void init();

    @SafeVarargs
    public final void add(T ... t) {
        for (T t1 : t) {
            this.addBy(t1, this.list.size());
        }
    }

    @SafeVarargs
    public final void remove(T ... t) {
        for (T t1 : t) {
            this.list.remove(t1);
            if (this.removeConsumer == null) continue;
            this.removeConsumer.accept(t1);
        }
    }

    public void addBy(T t, int index) {
        if (this.list.contains(t)) {
            return;
        }
        this.list.add(index, t);
        if (this.addConsumer != null) {
            this.addConsumer.accept(t);
        }
    }

    public void insert(T t, int index) {
        this.removeConsumer.accept(this.list.get(index));
        this.list.set(index, t);
        this.addConsumer.accept(this.list.get(index));
    }

    public void removeBy(int index) {
        this.list.remove(index);
    }

    public <V extends T> V getByClass(Class<V> clazz) {
        return this.list.stream().filter(t -> t.getClass() == clazz).findFirst().orElse(null);
    }

    public List<T> getList() {
        return this.list;
    }

    public void setAddConsumer(Consumer<T> addConsumer) {
        this.addConsumer = addConsumer;
    }

    public void setRemoveConsumer(Consumer<T> removeConsumer) {
        this.removeConsumer = removeConsumer;
    }
}

