/*
 * Decompiled with CFR 0.152.
 */
package de.florianmichael.rclasses.pattern.evicting;

import java.util.Collection;
import java.util.Collections;

public final class EvictingCollection<V> {
    private final Collection<V> collection;
    private final int maxSize;

    public EvictingCollection() {
        this(Collections.emptyList(), 0);
    }

    public EvictingCollection(Collection<V> collection, int maxSize) {
        this.collection = collection;
        this.maxSize = maxSize;
    }

    public boolean add(V value) {
        boolean full;
        boolean bl = full = this.collection.size() >= this.maxSize;
        if (full) {
            this.collection.remove(this.collection.iterator().next());
        }
        this.collection.add(value);
        return full;
    }

    public boolean isFull() {
        return this.collection.size() >= this.maxSize;
    }

    public Collection<V> getNormalCollection() {
        return this.collection;
    }

    public int getMaxSize() {
        return this.maxSize;
    }
}

