/*
 * Decompiled with CFR 0.152.
 */
package de.florianmichael.rclasses.pattern.evicting;

import java.util.Collections;
import java.util.Set;

public final class EvictingSet<V> {
    private final Set<V> set;
    private final int maxSize;

    public EvictingSet() {
        this(Collections.emptySet(), 0);
    }

    public EvictingSet(Set<V> set, int maxSize) {
        this.set = set;
        this.maxSize = maxSize;
    }

    public boolean add(V value) {
        boolean full;
        boolean bl = full = this.set.size() >= this.maxSize;
        if (full) {
            this.set.remove(this.set.toArray()[0]);
        }
        this.set.add(value);
        return full;
    }

    public boolean isFull() {
        return this.set.size() >= this.maxSize;
    }

    public Set<V> getNormalSet() {
        return this.set;
    }

    public int getMaxSize() {
        return this.maxSize;
    }
}

