/*
 * Decompiled with CFR 0.152.
 */
package de.florianmichael.rclasses.math;

import de.florianmichael.rclasses.math.Arithmetics;
import java.util.ArrayList;
import java.util.Collections;

public class Statistics {
    public static short averageShort(short ... data) {
        return (short)Arithmetics.clamp(Math.round((float)Arithmetics.sum(data) / (float)data.length), Short.MIN_VALUE, Short.MAX_VALUE);
    }

    public static short averageShort(int ... data) {
        return (short)Arithmetics.clamp(Math.round((float)Arithmetics.sum(data) / (float)data.length), Short.MIN_VALUE, Short.MAX_VALUE);
    }

    public static short averageShort(long ... data) {
        return (short)Arithmetics.clamp(Math.round((float)Arithmetics.sum(data) / (float)data.length), Short.MIN_VALUE, Short.MAX_VALUE);
    }

    public static short averageShort(float ... data) {
        return (short)Arithmetics.clamp(Math.round(Arithmetics.sum(data) / (float)data.length), Short.MIN_VALUE, Short.MAX_VALUE);
    }

    public static short averageShort(double ... data) {
        return (short)Arithmetics.clamp(Math.round(Arithmetics.clamp(Arithmetics.sum(data), -2.147483648E9, 2.147483647E9) / (double)data.length), -32768L, 32767L);
    }

    public static int averageInt(short ... data) {
        return Math.round((float)Arithmetics.sum(data) / (float)data.length);
    }

    public static int averageInt(int ... data) {
        return Math.round((float)Arithmetics.sum(data) / (float)data.length);
    }

    public static int averageInt(long ... data) {
        return Math.round((float)Arithmetics.sum(data) / (float)data.length);
    }

    public static int averageInt(float ... data) {
        return Math.round(Arithmetics.sum(data) / (float)data.length);
    }

    public static int averageInt(double ... data) {
        return (int)Math.round(Arithmetics.clamp(Arithmetics.sum(data), -2.147483648E9, 2.147483647E9) / (double)data.length);
    }

    public static float averageFloat(short ... data) {
        return (float)Arithmetics.sum(data) / (float)data.length;
    }

    public static float averageFloat(int ... data) {
        return (float)Arithmetics.sum(data) / (float)data.length;
    }

    public static float averageFloat(long ... data) {
        return (float)Arithmetics.sum(data) / (float)data.length;
    }

    public static float averageFloat(float ... data) {
        return Arithmetics.sum(data) / (float)data.length;
    }

    public static float averageFloat(double ... data) {
        return (float)Math.round(Arithmetics.sum(data)) / (float)data.length;
    }

    public static double averageDouble(short ... data) {
        return (double)Arithmetics.sum(data) / (double)data.length;
    }

    public static double averageDouble(int ... data) {
        return (double)Arithmetics.sum(data) / (double)data.length;
    }

    public static double averageDouble(long ... data) {
        return (double)Arithmetics.sum(data) / (double)data.length;
    }

    public static double averageDouble(float ... data) {
        return (double)Arithmetics.sum(data) / (double)data.length;
    }

    public static double averageDouble(double ... data) {
        return (double)Math.round(Arithmetics.sum(data)) / (double)data.length;
    }

    public static float median(float ... data) {
        return data.length % 2 == 0 ? (data[(int)((float)data.length * 0.5f)] + data[(int)((float)data.length * 0.5f) - 1]) * 0.5f : data[(int)((float)data.length * 0.5f)];
    }

    public static double median(double ... data) {
        return data.length % 2 == 0 ? (data[(int)((double)data.length * 0.5)] + data[(int)((double)data.length * 0.5) - 1]) * 0.5 : data[(int)((double)data.length * 0.5)];
    }

    public static float kurtosis(float ... data) {
        int count = data.length;
        if ((float)count < 3.0f) {
            return 0.0f;
        }
        float sum = Arithmetics.sum(data);
        float efficiencyFirst = (float)count * ((float)count + 1.0f) / (((float)count - 1.0f) * ((float)count - 2.0f) * ((float)count - 3.0f));
        float efficiencySecond = 3.0f * (float)Math.pow((float)count - 1.0f, 2.0) / (((float)count - 2.0f) * ((float)count - 3.0f));
        float average = sum / (float)count;
        float variance = 0.0f;
        float varianceSquared = 0.0f;
        for (float number : data) {
            variance += (float)Math.pow(average - number, 2.0);
            varianceSquared += (float)Math.pow(average - number, 4.0);
        }
        return efficiencyFirst * (varianceSquared / (float)Math.pow(variance / sum, 2.0)) - efficiencySecond;
    }

    public static double kurtosis(double ... data) {
        int count = data.length;
        if ((double)count < 3.0) {
            return 0.0;
        }
        double sum = Arithmetics.sum(data);
        double efficiencyFirst = (double)count * ((double)count + 1.0) / (((double)count - 1.0) * ((double)count - 2.0) * ((double)count - 3.0));
        double efficiencySecond = 3.0 * Math.pow((double)count - 1.0, 2.0) / (((double)count - 2.0) * ((double)count - 3.0));
        double average = sum / (double)count;
        double variance = 0.0;
        double varianceSquared = 0.0;
        for (double number : data) {
            variance += Math.pow(average - number, 2.0);
            varianceSquared += Math.pow(average - number, 4.0);
        }
        return efficiencyFirst * (varianceSquared / Math.pow(variance / sum, 2.0)) - efficiencySecond;
    }

    public static float skewness(float ... data) {
        int count = data.length;
        ArrayList<Float> numbers = new ArrayList<Float>(data.length);
        float sum = 0.0f;
        for (float number : data) {
            sum += number;
            numbers.add(Float.valueOf(number));
        }
        Collections.sort(numbers);
        float mean = sum / (float)count;
        float median = count % 2 != 0 ? ((Float)numbers.get(count / 2)).floatValue() : (((Float)numbers.get((count - 1) / 2)).floatValue() + ((Float)numbers.get(count / 2)).floatValue()) / 2.0f;
        float variance = Statistics.variance(data);
        return 3.0f * (mean - median) / variance;
    }

    public static double skewness(double ... data) {
        int count = data.length;
        ArrayList<Double> numbers = new ArrayList<Double>(data.length);
        double sum = 0.0;
        for (double number : data) {
            sum += number;
            numbers.add(number);
        }
        Collections.sort(numbers);
        double mean = sum / (double)count;
        double median = count % 2 != 0 ? (Double)numbers.get(count / 2) : ((Double)numbers.get((count - 1) / 2) + (Double)numbers.get(count / 2)) / 2.0;
        double variance = Statistics.variance(data);
        return 3.0 * (mean - median) / variance;
    }

    public static float variance(float ... data) {
        int count = data.length;
        double sum = Arithmetics.sum(data);
        double average = sum / (double)count;
        float variance = 0.0f;
        for (float number : data) {
            variance += (float)Math.pow((double)number - average, 2.0);
        }
        return variance / (float)count;
    }

    public static double variance(double ... data) {
        int count = data.length;
        double sum = Arithmetics.sum(data);
        double average = sum / (double)count;
        double variance = 0.0;
        for (double number : data) {
            variance += Math.pow(number - average, 2.0);
        }
        return variance / (double)count;
    }

    public static double variance(long ... data) {
        int count = data.length;
        double sum = Arithmetics.sum(data);
        double average = sum / (double)count;
        double variance = 0.0;
        long[] lArray = data;
        int n = lArray.length;
        for (int i = 0; i < n; ++i) {
            double number = lArray[i];
            variance += Math.pow(number - average, 2.0);
        }
        return variance / (double)count;
    }

    public static float standardDeviation(float ... data) {
        return (float)Math.sqrt(Statistics.variance(data));
    }

    public static double standardDeviation(double ... data) {
        return Math.sqrt(Statistics.variance(data));
    }

    public static double standardDeviation(long ... data) {
        return Math.sqrt(Statistics.variance(data));
    }
}

