/*
 * Decompiled with CFR 0.152.
 */
package de.florianmichael.rclasses.math;

public class Arithmetics {
    public static float interpolate(float start, float end, float progress) {
        return (1.0f - progress) * start + progress * end;
    }

    public static double interpolate(double start, double end, double progress) {
        return (1.0 - progress) * start + progress * end;
    }

    public static short conjugate(short value) {
        if (value == Short.MIN_VALUE) {
            return Short.MAX_VALUE;
        }
        if (value == Short.MAX_VALUE) {
            return Short.MIN_VALUE;
        }
        return -value;
    }

    public static int conjugate(int value) {
        if (value == Integer.MIN_VALUE) {
            return Integer.MAX_VALUE;
        }
        if (value == Integer.MAX_VALUE) {
            return Integer.MIN_VALUE;
        }
        return -value;
    }

    public static long conjugate(long value) {
        if (value == Long.MIN_VALUE) {
            return Long.MAX_VALUE;
        }
        if (value == Long.MAX_VALUE) {
            return Long.MIN_VALUE;
        }
        return -value;
    }

    public static float conjugate(float value) {
        if (value == Float.MIN_VALUE) {
            return Float.MAX_VALUE;
        }
        if (value == Float.MAX_VALUE) {
            return Float.MIN_VALUE;
        }
        return -value;
    }

    public static double conjugate(double value) {
        if (value == Double.MIN_VALUE) {
            return Double.MAX_VALUE;
        }
        if (value == Double.MAX_VALUE) {
            return Double.MIN_VALUE;
        }
        return -value;
    }

    public static short sum(short ... values) {
        short value = 0;
        for (short i : values) {
            value = (short)(value + i);
        }
        return value;
    }

    public static int sum(int ... values) {
        int value = 0;
        for (int i : values) {
            value += i;
        }
        return value;
    }

    public static long sum(long ... values) {
        long value = 0L;
        for (long i : values) {
            value += i;
        }
        return value;
    }

    public static float sum(float ... values) {
        float value = 0.0f;
        for (float f : values) {
            value += f;
        }
        return value;
    }

    public static double sum(double ... values) {
        double value = 0.0;
        for (double d : values) {
            value += d;
        }
        return value;
    }

    public static short clamp(short value, short minimum, short maximum) {
        return (short)Math.max(minimum, Math.min(maximum, value));
    }

    public static int clamp(int value, int minimum, int maximum) {
        return Math.max(minimum, Math.min(maximum, value));
    }

    public static long clamp(long value, long minimum, long maximum) {
        return Math.max(minimum, Math.min(maximum, value));
    }

    public static float clamp(float value, float minimum, float maximum) {
        return Math.max(minimum, Math.min(maximum, value));
    }

    public static double clamp(double value, double minimum, double maximum) {
        return Math.max(minimum, Math.min(maximum, value));
    }

    public static double roundAwayFromZero(double x) {
        return x < 0.0 ? Math.floor(x) : (x > 0.0 ? Math.ceil(x) : x);
    }

    public static double roundAvoid(double value, int places) {
        double scale = Math.pow(10.0, places);
        return (double)Math.round(value * scale) / scale;
    }

    public static float roundAvoid(float value, int places) {
        float scale = (float)Math.pow(10.0, places);
        return (float)Math.round(value * scale) / scale;
    }

    public static boolean isDecimal(float value) {
        return value % 1.0f != 0.0f;
    }

    public static boolean isDecimal(double value) {
        return value % 1.0 != 0.0;
    }
}

