/*
 * Decompiled with CFR 0.152.
 */
package de.florianmichael.rclasses.math.geometry.impl;

import de.florianmichael.rclasses.math.geometry.impl.TrigonometryBase;

public class RivensFullTrigonometry
implements TrigonometryBase {
    private static final float BF_SIN_TO_COS = 1.5707964f;
    private static final int BF_SIN_BITS = 12;
    private static final int BF_SIN_MASK = ~(-1 << BF_SIN_BITS);
    private static final int BF_SIN_COUNT = BF_SIN_MASK + 1;
    private static final float BF_radFull = (float)Math.PI * 2;
    private static final float BF_radToIndex = (float)BF_SIN_COUNT / BF_radFull;
    private static final float[] BF_sinFull = new float[BF_SIN_COUNT];

    @Override
    public float sin(float x) {
        return BF_sinFull[(int)(x * BF_radToIndex) & BF_SIN_MASK];
    }

    @Override
    public float cos(float x) {
        return this.sin(x + BF_SIN_TO_COS);
    }

    static {
        for (int i = 0; i < BF_SIN_COUNT; ++i) {
            RivensFullTrigonometry.BF_sinFull[i] = (float)Math.sin(((double)i + (double)Math.min(1, i % (BF_SIN_COUNT / 4)) * 0.5) / (double)BF_SIN_COUNT * (double)BF_radFull);
        }
    }
}

