/*
 * Decompiled with CFR 0.152.
 */
package de.florianmichael.rclasses.math.geometry;

import de.florianmichael.rclasses.math.geometry.impl.JavaTrigonometry;
import de.florianmichael.rclasses.math.geometry.impl.LibGDXTrigonometry;
import de.florianmichael.rclasses.math.geometry.impl.MinecraftTrigonometry;
import de.florianmichael.rclasses.math.geometry.impl.OptifineD5Trigonometry;
import de.florianmichael.rclasses.math.geometry.impl.OptifineK4Trigonometry;
import de.florianmichael.rclasses.math.geometry.impl.RandomTrigonometry;
import de.florianmichael.rclasses.math.geometry.impl.RivensFullTrigonometry;
import de.florianmichael.rclasses.math.geometry.impl.RivensHalfTrigonometry;
import de.florianmichael.rclasses.math.geometry.impl.RivensTrigonometry;
import de.florianmichael.rclasses.math.geometry.impl.TaylorTrigonometry;
import de.florianmichael.rclasses.math.geometry.impl.TrigonometryBase;

public enum Trigonometry implements TrigonometryBase
{
    MINECRAFT("Minecraft", new MinecraftTrigonometry()),
    OPTIFINE_D5("Optifine <= D5", new OptifineD5Trigonometry()),
    OPTIFINE_K4("Optifine >= K4", new OptifineK4Trigonometry()),
    JAVA("Java", new JavaTrigonometry()),
    LIB_GDX("LibGDX", new LibGDXTrigonometry()),
    RANDOM("Random", new RandomTrigonometry()),
    RIVENS_FULL("Rivens Full", new RivensFullTrigonometry()),
    RIVENS_HALF("Rivens Half", new RivensHalfTrigonometry()),
    RIVENS("Rivens", new RivensTrigonometry()),
    TAYLOR("Taylor", new TaylorTrigonometry());

    public final String name;
    public final TrigonometryBase math;

    private Trigonometry(String name, TrigonometryBase math) {
        this.name = name;
        this.math = math;
    }

    @Override
    public float sin(float x) {
        return this.math.sin(x);
    }

    @Override
    public float cos(float x) {
        return this.math.cos(x);
    }
}

