/*
 * Decompiled with CFR 0.152.
 */
package de.florianmichael.rclasses.math.trigonometry.impl;

import de.florianmichael.rclasses.math.trigonometry.Trigonometry;

public class LibGDXTrigonometry
implements Trigonometry {
    public static final float BF_PI = (float)Math.PI;
    private static final int BF_SIN_BITS = 14;
    private static final int BF_SIN_MASK = 16383;
    private static final int BF_SIN_COUNT = 16384;
    private static final float BF_radFull = (float)Math.PI * 2;
    private static final float BF_degFull = 360.0f;
    private static final float BF_radToIndex = 2607.5945f;
    private static final float BF_degToIndex = 45.511112f;
    public static final float BF_degreesToRadians = (float)Math.PI / 180;
    private static final float[] BF_table;

    @Override
    public float sin(float x) {
        return BF_table[(int)(x * 2607.5945f) & 0x3FFF];
    }

    @Override
    public float cos(float x) {
        return BF_table[(int)((x + 1.5707964f) * 2607.5945f) & 0x3FFF];
    }

    static {
        int i;
        BF_table = new float[16384];
        for (i = 0; i < 16384; ++i) {
            LibGDXTrigonometry.BF_table[i] = (float)Math.sin(((float)i + 0.5f) / 16384.0f * ((float)Math.PI * 2));
        }
        for (i = 0; i < 360; i += 90) {
            LibGDXTrigonometry.BF_table[(int)((float)i * 45.511112f) & 0x3FFF] = (float)Math.sin((float)i * ((float)Math.PI / 180));
        }
    }
}

