/*
 * Decompiled with CFR 0.152.
 */
package de.florianmichael.rclasses.math.concept;

public class MSTimer {
    private long time = System.currentTimeMillis();
    private boolean paused = false;
    private long pausedTime = 0L;

    public void pause() {
        if (this.paused) {
            return;
        }
        this.pausedTime = this.getDelta();
        this.paused = true;
    }

    public void resume() {
        if (!this.paused) {
            return;
        }
        this.paused = false;
        this.pausedTime = 0L;
    }

    public void reset() {
        this.time = System.currentTimeMillis();
    }

    public boolean hasReached(long delay) {
        return this.getDelta() >= delay;
    }

    public long getDelta() {
        return System.currentTimeMillis() - this.getTime();
    }

    public long getTime() {
        return this.paused ? this.pausedTime : this.time;
    }

    public void setTime(long time) {
        this.time = time;
    }
}

