/*
 * Decompiled with CFR 0.152.
 */
package de.florianmichael.rclasses.math.concept;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum EasingFunctions {
    LINEAR("Linear", x -> x),
    IN_SINE("In sine", x -> Float.valueOf((float)(1.0 - Math.cos((double)x.floatValue() * Math.PI * 0.5)))),
    OUT_SINE("Out sine", x -> Float.valueOf((float)Math.sin((double)x.floatValue() * Math.PI * 0.5))),
    IN_OUT_SINE("In out sine", x -> Float.valueOf((float)(-(Math.cos(Math.PI * (double)x.floatValue()) - 1.0) * 0.5))),
    IN_QUAD("In quad", x -> Float.valueOf(x.floatValue() * x.floatValue())),
    OUT_QUAD("Out quad", x -> Float.valueOf(1.0f - (1.0f - x.floatValue()) * (1.0f - x.floatValue()))),
    IN_OUT_QUAD("In out quad", x -> Float.valueOf(x.floatValue() < 0.5f ? 2.0f * x.floatValue() * x.floatValue() : 1.0f - (float)Math.pow(-2.0f * x.floatValue() + 2.0f, 2.0) * 0.5f)),
    IN_CUBIC("In cubic", x -> Float.valueOf((float)Math.pow(x.floatValue(), 3.0))),
    OUT_CUBIC("Out cubic", x -> Float.valueOf((float)(1.0 - Math.pow(1.0f - x.floatValue(), 3.0)))),
    IN_OUT_CUBIC("In out cubic", x -> Float.valueOf(x.floatValue() < 0.5f ? 4.0f * x.floatValue() * x.floatValue() * x.floatValue() : 1.0f - (float)Math.pow(-2.0f * x.floatValue() + 2.0f, 3.0) * 0.5f)),
    IN_QUART("In quart", x -> Float.valueOf((float)Math.pow(x.floatValue(), 4.0))),
    OUT_QUART("Out quart", x -> Float.valueOf((float)(1.0 - Math.pow(1.0f - x.floatValue(), 4.0)))),
    IN_OUT_QUART("In out quart", x -> Float.valueOf(x.floatValue() < 0.5f ? 8.0f * x.floatValue() * x.floatValue() * x.floatValue() * x.floatValue() : 1.0f - (float)Math.pow(-2.0f * x.floatValue() + 2.0f, 4.0) * 0.5f)),
    IN_QUINT("In quint", x -> Float.valueOf((float)Math.pow(x.floatValue(), 5.0))),
    OUT_QUINT("Out quint", x -> Float.valueOf((float)(1.0 - Math.pow(1.0f - x.floatValue(), 5.0)))),
    IN_OUT_QUINT("In out quint", x -> Float.valueOf(x.floatValue() < 0.5f ? 16.0f * x.floatValue() * x.floatValue() * x.floatValue() * x.floatValue() * x.floatValue() : 1.0f - (float)Math.pow(-2.0f * x.floatValue() + 2.0f, 5.0) * 0.5f)),
    IN_EXPO("In expo", x -> Float.valueOf(x.floatValue() == 0.0f ? 0.0f : (float)Math.pow(2.0, 10.0f * x.floatValue() - 10.0f))),
    OUT_EXPO("Out expo", x -> Float.valueOf(x.floatValue() == 1.0f ? 1.0f : 1.0f - (float)Math.pow(2.0, -10.0f * x.floatValue()))),
    IN_OUT_EXPO("In out expo", x -> Float.valueOf(x.floatValue() == 0.0f ? 0.0f : (x.floatValue() == 1.0f ? 1.0f : (x.floatValue() < 0.5f ? (float)Math.pow(2.0, 20.0f * x.floatValue() - 10.0f) * 0.5f : (2.0f - (float)Math.pow(2.0, -20.0f * x.floatValue() + 10.0f)) * 0.5f)))),
    IN_CIRC("In circ", x -> Float.valueOf(1.0f - (float)Math.sqrt(1.0f - (float)Math.pow(x.floatValue(), 2.0)))),
    OUT_CIRC("Out circ", x -> Float.valueOf((float)Math.sqrt(1.0f - (float)Math.pow(x.floatValue() - 1.0f, 2.0)))),
    IN_OUT_CIRC("In out circ", x -> Float.valueOf(x.floatValue() < 0.5f ? (1.0f - (float)Math.sqrt(1.0f - (float)Math.pow(2.0f * x.floatValue(), 2.0))) * 0.5f : ((float)Math.sqrt(1.0f - (float)Math.pow(-2.0f * x.floatValue() + 2.0f, 2.0)) + 1.0f) * 0.5f)),
    IN_BACK("In back", x -> {
        float c1 = 1.70158f;
        float c3 = 2.70158f;
        return Float.valueOf(2.70158f * x.floatValue() * x.floatValue() * x.floatValue() - 1.70158f * x.floatValue() * x.floatValue());
    }),
    OUT_BACK("Out back", x -> {
        float c1 = 1.70158f;
        float c3 = 2.70158f;
        return Float.valueOf(1.0f + 2.70158f * (float)Math.pow(x.floatValue() - 1.0f, 3.0) + 1.70158f * (float)Math.pow(x.floatValue() - 1.0f, 2.0));
    }),
    IN_OUT_BACK("In out back", x -> {
        float c1 = 1.70158f;
        float c2 = 2.5949094f;
        return Float.valueOf(x.floatValue() < 0.5f ? (float)Math.pow(2.0f * x.floatValue(), 2.0) * (7.189819f * x.floatValue() - 2.5949094f) * 0.5f : ((float)Math.pow(2.0f * x.floatValue() - 2.0f, 2.0) * (3.5949094f * (x.floatValue() * 2.0f - 2.0f) + 2.5949094f) + 2.0f) * 0.5f);
    }),
    IN_ELASTIC("In elastic", x -> {
        float c4 = 2.0943952f;
        return Float.valueOf(x.floatValue() == 0.0f ? 0.0f : (x.floatValue() == 1.0f ? 1.0f : (float)(-Math.pow(2.0, 10.0f * x.floatValue() - 10.0f)) * (float)Math.sin((x.floatValue() * 10.0f - 10.75f) * 2.0943952f)));
    }),
    OUT_ELASTIC("Out elastic", x -> {
        float c4 = 2.0943952f;
        return Float.valueOf(x.floatValue() == 0.0f ? 0.0f : (x.floatValue() == 1.0f ? 1.0f : (float)Math.pow(2.0, -10.0f * x.floatValue()) * (float)Math.sin((x.floatValue() * 10.0f - 0.75f) * 2.0943952f) + 1.0f));
    }),
    IN_OUT_ELASTIC("In out elastic", x -> {
        float c5 = 1.3962635f;
        double curvature = Math.sin((20.0f * x.floatValue() - 11.125f) * 1.3962635f);
        return Float.valueOf(x.floatValue() == 0.0f ? 0.0f : (x.floatValue() == 1.0f ? 1.0f : (x.floatValue() < 0.5f ? -((float)Math.pow(2.0, 20.0f * x.floatValue() - 10.0f) * (float)curvature) * 0.5f : (float)Math.pow(2.0, -20.0f * x.floatValue() + 10.0f) * (float)curvature * 0.5f + 1.0f)));
    }),
    OUT_BOUNCE("Out bounce", x -> {
        float f;
        float n1 = 7.5625f;
        float d1 = 2.75f;
        if (x.floatValue() < 0.36363637f) {
            f = 7.5625f * x.floatValue() * x.floatValue();
        } else if (x.floatValue() < 0.72727275f) {
            x = Float.valueOf(x.floatValue() - 0.54545456f);
            f = 7.5625f * x.floatValue() * x.floatValue() + 0.75f;
        } else if (x.floatValue() < 0.90909094f) {
            x = Float.valueOf(x.floatValue() - 0.8181818f);
            f = 7.5625f * x.floatValue() * x.floatValue() + 0.9375f;
        } else {
            x = Float.valueOf(x.floatValue() - 0.95454544f);
            f = 7.5625f * x.floatValue() * x.floatValue() + 0.984375f;
        }
        return Float.valueOf(f);
    }),
    IN_BOUNCE("In bounce", x -> Float.valueOf(1.0f - OUT_BOUNCE.ease(1.0f - x.floatValue()))),
    IN_OUT_BOUNCE("In out bounce", x -> Float.valueOf(x.floatValue() < 0.5f ? (1.0f - OUT_BOUNCE.ease(1.0f - 2.0f * x.floatValue())) * 0.5f : (1.0f + OUT_BOUNCE.ease(2.0f * x.floatValue() - 1.0f)) * 0.5f));

    public final String name;
    public final Function<Float, Float> function;

    private EasingFunctions(String name, Function<Float, Float> function) {
        this.name = name;
        this.function = function;
    }

    public static List<String> functionNames() {
        return Arrays.stream(EasingFunctions.values()).map(EasingFunctions::getName).collect(Collectors.toList());
    }

    public static float ease(String functionName, float x) {
        return EasingFunctions.byName(functionName).ease(x);
    }

    public static EasingFunctions byName(String functionName) {
        for (EasingFunctions value : EasingFunctions.values()) {
            if (!value.name.equals(functionName)) continue;
            return value;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public String upperName() {
        return this.name.toUpperCase(Locale.ROOT);
    }

    public String lowerName() {
        return this.name.toLowerCase(Locale.ROOT);
    }

    public float ease(float x) {
        return this.function.apply(Float.valueOf(x)).floatValue();
    }
}

