/*
 * Decompiled with CFR 0.152.
 */
package de.florianmichael.rclasses.math;

import de.florianmichael.rclasses.math.trigonometry.TrigonometryFunctions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;

public class MathUtils {
    public static final float TAU = (float)Math.PI * 2;

    public static float interpolate(float start, float end, float progress) {
        return (1.0f - progress) * start + progress * end;
    }

    public static double interpolate(double start, double end, double progress) {
        return (1.0 - progress) * start + progress * end;
    }

    public static short conjugate(short value) {
        if (value == Short.MIN_VALUE) {
            return Short.MAX_VALUE;
        }
        if (value == Short.MAX_VALUE) {
            return Short.MIN_VALUE;
        }
        return -value;
    }

    public static int conjugate(int value) {
        if (value == Integer.MIN_VALUE) {
            return Integer.MAX_VALUE;
        }
        if (value == Integer.MAX_VALUE) {
            return Integer.MIN_VALUE;
        }
        return -value;
    }

    public static long conjugate(long value) {
        if (value == Long.MIN_VALUE) {
            return Long.MAX_VALUE;
        }
        if (value == Long.MAX_VALUE) {
            return Long.MIN_VALUE;
        }
        return -value;
    }

    public static float conjugate(float value) {
        if (value == Float.MIN_VALUE) {
            return Float.MAX_VALUE;
        }
        if (value == Float.MAX_VALUE) {
            return Float.MIN_VALUE;
        }
        return -value;
    }

    public static double conjugate(double value) {
        if (value == Double.MIN_VALUE) {
            return Double.MAX_VALUE;
        }
        if (value == Double.MAX_VALUE) {
            return Double.MIN_VALUE;
        }
        return -value;
    }

    public static boolean isInBounds(short x, short y, short left, short up, short right, short down) {
        return x >= left && x <= left + right && y >= up && y <= up + down;
    }

    public static boolean isInBounds(int x, int y, int left, int up, int right, int down) {
        return x >= left && x <= left + right && y >= up && y <= up + down;
    }

    public static boolean isInBounds(long x, long y, long left, long up, long right, long down) {
        return x >= left && x <= left + right && y >= up && y <= up + down;
    }

    public static boolean isInBounds(float x, float y, float left, float up, float right, float down) {
        return x >= left && x <= left + right && y >= up && y <= up + down;
    }

    public static boolean isInBounds(double x, double y, double left, double up, double right, double down) {
        return x >= left && x <= left + right && y >= up && y <= up + down;
    }

    public static boolean isInBoundsAbsolute(short x, short y, short left, short up, short right, short down) {
        return x >= left && x <= right && y >= up && y <= down;
    }

    public static boolean isInBoundsAbsolute(int x, int y, int left, int up, int right, int down) {
        return x >= left && x <= right && y >= up && y <= down;
    }

    public static boolean isInBoundsAbsolute(long x, long y, long left, long up, long right, long down) {
        return x >= left && x <= right && y >= up && y <= down;
    }

    public static boolean isInBoundsAbsolute(float x, float y, float left, float up, float right, float down) {
        return x >= left && x <= right && y >= up && y <= down;
    }

    public static boolean isInBoundsAbsolute(double x, double y, double left, double up, double right, double down) {
        return x >= left && x <= right && y >= up && y <= down;
    }

    public static double roundAvoid(double value, int places) {
        double scale = Math.pow(10.0, places);
        return (double)Math.round(value * scale) / scale;
    }

    public static float roundAvoid(float value, int places) {
        float scale = (float)Math.pow(10.0, places);
        return (float)Math.round(value * scale) / scale;
    }

    public static short sum(short ... values) {
        short value = 0;
        for (short i : values) {
            value = (short)(value + i);
        }
        return value;
    }

    public static int sum(int ... values) {
        int value = 0;
        for (int i : values) {
            value += i;
        }
        return value;
    }

    public static long sum(long ... values) {
        long value = 0L;
        for (long i : values) {
            value += i;
        }
        return value;
    }

    public static float sum(float ... values) {
        float value = 0.0f;
        for (float f : values) {
            value += f;
        }
        return value;
    }

    public static double sum(double ... values) {
        double value = 0.0;
        for (double d : values) {
            value += d;
        }
        return value;
    }

    public static short averageShort(short ... data) {
        return (short)MathUtils.clamp(Math.round((float)MathUtils.sum(data) / (float)data.length), Short.MIN_VALUE, Short.MAX_VALUE);
    }

    public static short averageShort(int ... data) {
        return (short)MathUtils.clamp(Math.round((float)MathUtils.sum(data) / (float)data.length), Short.MIN_VALUE, Short.MAX_VALUE);
    }

    public static short averageShort(long ... data) {
        return (short)MathUtils.clamp(Math.round((float)MathUtils.sum(data) / (float)data.length), Short.MIN_VALUE, Short.MAX_VALUE);
    }

    public static short averageShort(float ... data) {
        return (short)MathUtils.clamp(Math.round(MathUtils.sum(data) / (float)data.length), Short.MIN_VALUE, Short.MAX_VALUE);
    }

    public static short averageShort(double ... data) {
        return (short)MathUtils.clamp(Math.round(MathUtils.clamp(MathUtils.sum(data), -2.147483648E9, 2.147483647E9) / (double)data.length), -32768L, 32767L);
    }

    public static int averageInt(short ... data) {
        return Math.round((float)MathUtils.sum(data) / (float)data.length);
    }

    public static int averageInt(int ... data) {
        return Math.round((float)MathUtils.sum(data) / (float)data.length);
    }

    public static int averageInt(long ... data) {
        return Math.round((float)MathUtils.sum(data) / (float)data.length);
    }

    public static int averageInt(float ... data) {
        return Math.round(MathUtils.sum(data) / (float)data.length);
    }

    public static int averageInt(double ... data) {
        return (int)Math.round(MathUtils.clamp(MathUtils.sum(data), -2.147483648E9, 2.147483647E9) / (double)data.length);
    }

    public static float averageFloat(short ... data) {
        return (float)MathUtils.sum(data) / (float)data.length;
    }

    public static float averageFloat(int ... data) {
        return (float)MathUtils.sum(data) / (float)data.length;
    }

    public static float averageFloat(long ... data) {
        return (float)MathUtils.sum(data) / (float)data.length;
    }

    public static float averageFloat(float ... data) {
        return MathUtils.sum(data) / (float)data.length;
    }

    public static float averageFloat(double ... data) {
        return (float)Math.round(MathUtils.sum(data)) / (float)data.length;
    }

    public static double averageDouble(short ... data) {
        return (double)MathUtils.sum(data) / (double)data.length;
    }

    public static double averageDouble(int ... data) {
        return (double)MathUtils.sum(data) / (double)data.length;
    }

    public static double averageDouble(long ... data) {
        return (double)MathUtils.sum(data) / (double)data.length;
    }

    public static double averageDouble(float ... data) {
        return (double)MathUtils.sum(data) / (double)data.length;
    }

    public static double averageDouble(double ... data) {
        return (double)Math.round(MathUtils.sum(data)) / (double)data.length;
    }

    public static short clamp(short value, short minimum, short maximum) {
        return (short)Math.max(minimum, Math.min(maximum, value));
    }

    public static int clamp(int value, int minimum, int maximum) {
        return Math.max(minimum, Math.min(maximum, value));
    }

    public static long clamp(long value, long minimum, long maximum) {
        return Math.max(minimum, Math.min(maximum, value));
    }

    public static float clamp(float value, float minimum, float maximum) {
        return Math.max(minimum, Math.min(maximum, value));
    }

    public static double clamp(double value, double minimum, double maximum) {
        return Math.max(minimum, Math.min(maximum, value));
    }

    public static float median(float ... data) {
        return data.length % 2 == 0 ? (data[(int)((float)data.length * 0.5f)] + data[(int)((float)data.length * 0.5f) - 1]) * 0.5f : data[(int)((float)data.length * 0.5f)];
    }

    public static double median(double ... data) {
        return data.length % 2 == 0 ? (data[(int)((double)data.length * 0.5)] + data[(int)((double)data.length * 0.5) - 1]) * 0.5 : data[(int)((double)data.length * 0.5)];
    }

    public static float kurtosis(float ... data) {
        int count = data.length;
        if ((float)count < 3.0f) {
            return 0.0f;
        }
        float sum = MathUtils.sum(data);
        float efficiencyFirst = (float)count * ((float)count + 1.0f) / (((float)count - 1.0f) * ((float)count - 2.0f) * ((float)count - 3.0f));
        float efficiencySecond = 3.0f * (float)Math.pow((float)count - 1.0f, 2.0) / (((float)count - 2.0f) * ((float)count - 3.0f));
        float average = sum / (float)count;
        float variance = 0.0f;
        float varianceSquared = 0.0f;
        for (float number : data) {
            variance += (float)Math.pow(average - number, 2.0);
            varianceSquared += (float)Math.pow(average - number, 4.0);
        }
        return efficiencyFirst * (varianceSquared / (float)Math.pow(variance / sum, 2.0)) - efficiencySecond;
    }

    public static double kurtosis(double ... data) {
        int count = data.length;
        if ((double)count < 3.0) {
            return 0.0;
        }
        double sum = MathUtils.sum(data);
        double efficiencyFirst = (double)count * ((double)count + 1.0) / (((double)count - 1.0) * ((double)count - 2.0) * ((double)count - 3.0));
        double efficiencySecond = 3.0 * Math.pow((double)count - 1.0, 2.0) / (((double)count - 2.0) * ((double)count - 3.0));
        double average = sum / (double)count;
        double variance = 0.0;
        double varianceSquared = 0.0;
        for (double number : data) {
            variance += Math.pow(average - number, 2.0);
            varianceSquared += Math.pow(average - number, 4.0);
        }
        return efficiencyFirst * (varianceSquared / Math.pow(variance / sum, 2.0)) - efficiencySecond;
    }

    public static float skewness(float ... data) {
        int count = data.length;
        ArrayList<Float> numbers = new ArrayList<Float>(data.length);
        float sum = 0.0f;
        for (float number : data) {
            sum += number;
            numbers.add(Float.valueOf(number));
        }
        Collections.sort(numbers);
        float mean = sum / (float)count;
        float median = count % 2 != 0 ? ((Float)numbers.get(count / 2)).floatValue() : (((Float)numbers.get((count - 1) / 2)).floatValue() + ((Float)numbers.get(count / 2)).floatValue()) / 2.0f;
        float variance = MathUtils.variance(data);
        return 3.0f * (mean - median) / variance;
    }

    public static double skewness(double ... data) {
        int count = data.length;
        ArrayList<Double> numbers = new ArrayList<Double>(data.length);
        double sum = 0.0;
        for (double number : data) {
            sum += number;
            numbers.add(number);
        }
        Collections.sort(numbers);
        double mean = sum / (double)count;
        double median = count % 2 != 0 ? (Double)numbers.get(count / 2) : ((Double)numbers.get((count - 1) / 2) + (Double)numbers.get(count / 2)) / 2.0;
        double variance = MathUtils.variance(data);
        return 3.0 * (mean - median) / variance;
    }

    public static float variance(float ... data) {
        int count = data.length;
        double sum = MathUtils.sum(data);
        double average = sum / (double)count;
        float variance = 0.0f;
        for (float number : data) {
            variance += (float)Math.pow((double)number - average, 2.0);
        }
        return variance / (float)count;
    }

    public static double variance(double ... data) {
        int count = data.length;
        double sum = MathUtils.sum(data);
        double average = sum / (double)count;
        double variance = 0.0;
        for (double number : data) {
            variance += Math.pow(number - average, 2.0);
        }
        return variance / (double)count;
    }

    public static double variance(long ... data) {
        int count = data.length;
        double sum = MathUtils.sum(data);
        double average = sum / (double)count;
        double variance = 0.0;
        long[] lArray = data;
        int n = lArray.length;
        for (int i = 0; i < n; ++i) {
            double number = lArray[i];
            variance += Math.pow(number - average, 2.0);
        }
        return variance / (double)count;
    }

    public static float standardDeviation(float ... data) {
        return (float)Math.sqrt(MathUtils.variance(data));
    }

    public static double standardDeviation(double ... data) {
        return Math.sqrt(MathUtils.variance(data));
    }

    public static double standardDeviation(long ... data) {
        return Math.sqrt(MathUtils.variance(data));
    }

    public static double roundAwayFromZero(double x) {
        return x < 0.0 ? Math.floor(x) : (x > 0.0 ? Math.ceil(x) : x);
    }

    public static float boxMuellerDistribution(Random random, float min, float max, float mean, float sigma) {
        float u2;
        float u1;
        float z0;
        do {
            u1 = random.nextFloat();
            u2 = random.nextFloat();
        } while ((float)((int)((z0 = (float)Math.sqrt(-2.0f * (float)Math.log(u1)) * TrigonometryFunctions.MINECRAFT.cos((float)Math.PI * 2 * u2)) * sigma + mean)) < min || (float)((int)(z0 * sigma + mean)) > max);
        return mean + sigma * z0;
    }

    public static double boxMuellerDistribution(Random random, double min, double max, double mean, double sigma) {
        double u2;
        double u1;
        double z0;
        do {
            u1 = random.nextFloat();
            u2 = random.nextFloat();
        } while ((double)((int)((z0 = Math.sqrt(-2.0f * (float)Math.log(u1)) * (double)TrigonometryFunctions.MINECRAFT.cos((float)(6.2831854820251465 * u2))) * sigma + mean)) < min || (double)((int)(z0 * sigma + mean)) > max);
        return mean + sigma * z0;
    }
}

