/*
 * Decompiled with CFR 0.152.
 */
package de.florianmichael.rclasses.functional.tuple.immutable;

import de.florianmichael.rclasses.functional.tuple.Triplet;
import java.util.Objects;

public final class ImmutableTriplet<A, B, C>
extends Triplet<A, B, C> {
    private static final UnsupportedOperationException COULD_NOT_SET = new UnsupportedOperationException("The object is immutable!");
    private final A first;
    private final B second;
    private final C third;

    public ImmutableTriplet() {
        this(null, null, null);
    }

    public ImmutableTriplet(A first, B second, C third) {
        this.first = first;
        this.second = second;
        this.third = third;
    }

    @Override
    public A getFirst() {
        return this.first;
    }

    @Override
    public B getSecond() {
        return this.second;
    }

    @Override
    public C getThird() {
        return this.third;
    }

    @Override
    public void setFirst(A first) throws UnsupportedOperationException {
        throw COULD_NOT_SET;
    }

    @Override
    public void setSecond(B second) throws UnsupportedOperationException {
        throw COULD_NOT_SET;
    }

    @Override
    public void setThird(C third) throws UnsupportedOperationException {
        throw COULD_NOT_SET;
    }

    @Override
    public String toString() {
        return "ImmutableTriplet{first=" + this.first + ", second=" + this.second + ", third=" + this.third + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableTriplet that = (ImmutableTriplet)o;
        return Objects.equals(this.first, that.first) && Objects.equals(this.second, that.second) && Objects.equals(this.third, that.third);
    }

    public int hashCode() {
        return Objects.hash(this.first, this.second, this.third);
    }
}

