/*
 * Decompiled with CFR 0.152.
 */
package de.florianmichael.rclasses.functional.tuple.immutable;

import de.florianmichael.rclasses.functional.tuple.Quartet;
import java.util.Objects;

public final class ImmutableQuartet<A, B, C, D>
extends Quartet<A, B, C, D> {
    private static final UnsupportedOperationException COULD_NOT_SET = new UnsupportedOperationException("The object is immutable!");
    private final A first;
    private final B second;
    private final C third;
    private final D fourth;

    public ImmutableQuartet() {
        this(null, null, null, null);
    }

    public ImmutableQuartet(A first, B second, C third, D fourth) {
        this.first = first;
        this.second = second;
        this.third = third;
        this.fourth = fourth;
    }

    @Override
    public A getFirst() {
        return this.first;
    }

    @Override
    public B getSecond() {
        return this.second;
    }

    @Override
    public C getThird() {
        return this.third;
    }

    @Override
    public D getFourth() {
        return this.fourth;
    }

    @Override
    public void setFirst(A first) throws UnsupportedOperationException {
        throw COULD_NOT_SET;
    }

    @Override
    public void setSecond(B second) throws UnsupportedOperationException {
        throw COULD_NOT_SET;
    }

    @Override
    public void setThird(C third) throws UnsupportedOperationException {
        throw COULD_NOT_SET;
    }

    @Override
    public void setFourth(D fourth) throws UnsupportedOperationException {
        throw COULD_NOT_SET;
    }

    @Override
    public String toString() {
        return "ImmutableQuartet{first=" + this.first + ", second=" + this.second + ", third=" + this.third + ", fourth=" + this.fourth + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableQuartet that = (ImmutableQuartet)o;
        return Objects.equals(this.first, that.first) && Objects.equals(this.second, that.second) && Objects.equals(this.third, that.third) && Objects.equals(this.fourth, that.fourth);
    }

    public int hashCode() {
        return Objects.hash(this.first, this.second, this.third, this.fourth);
    }
}

