/*
 * Decompiled with CFR 0.152.
 */
package de.florianmichael.rclasses.functional.tuple.immutable;

import de.florianmichael.rclasses.functional.tuple.Pair;
import java.util.Objects;

public final class ImmutablePair<A, B>
extends Pair<A, B> {
    private static final UnsupportedOperationException COULD_NOT_SET = new UnsupportedOperationException("The object is immutable!");
    private final A first;
    private final B second;

    public ImmutablePair() {
        this(null, null);
    }

    public ImmutablePair(A first, B second) {
        this.first = first;
        this.second = second;
    }

    @Override
    public A getFirst() {
        return this.first;
    }

    @Override
    public B getSecond() {
        return this.second;
    }

    @Override
    public void setFirst(A first) throws UnsupportedOperationException {
        throw COULD_NOT_SET;
    }

    @Override
    public void setSecond(B second) throws UnsupportedOperationException {
        throw COULD_NOT_SET;
    }

    @Override
    public String toString() {
        return "ImmutablePair{first=" + this.first + ", second=" + this.second + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutablePair that = (ImmutablePair)o;
        return Objects.equals(this.first, that.first) && Objects.equals(this.second, that.second);
    }

    public int hashCode() {
        return Objects.hash(this.first, this.second);
    }
}

