/*
 * Decompiled with CFR 0.152.
 */
package de.florianmichael.rclasses.common.hardware;

import de.florianmichael.rclasses.common.hardware.OSArchitecture;

public enum OperatingSystem {
    WINDOWS,
    LINUX,
    MAC,
    SOLARIS,
    UNKNOWN;


    public static OperatingSystem getOS() {
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.contains("win")) {
            return WINDOWS;
        }
        if (osName.contains("nix") || osName.contains("nux") || osName.contains("aix")) {
            return LINUX;
        }
        if (osName.contains("mac") || osName.contains("osx")) {
            return MAC;
        }
        if (osName.contains("sunos") || osName.contains("solaris")) {
            return SOLARIS;
        }
        return UNKNOWN;
    }

    public static OSArchitecture getArchitecture() {
        return new OSArchitecture(System.getProperty("os.arch"));
    }

    public static String getNativeExtension() {
        switch (OperatingSystem.getOS()) {
            case WINDOWS: {
                return "dll";
            }
            case MAC: {
                return "dylib";
            }
        }
        return "so";
    }
}

