/*
 * Decompiled with CFR 0.152.
 */
package de.florianmichael.rclasses.common.hardware;

import java.util.Objects;

public class OSArchitecture {
    public final boolean amd64;
    public final boolean x86;
    public final boolean arm64;
    public final boolean arm;
    public final boolean ia64;
    public final boolean mips64;
    public final boolean mips;
    public final boolean ppc64;
    public final boolean s390x;
    public final boolean sparc;
    public final boolean s390;

    public OSArchitecture(String archString) {
        archString = archString.toLowerCase();
        this.amd64 = archString.contains("amd64");
        this.x86 = archString.contains("x86_64") || archString.contains("x86-64") || archString.contains("x64");
        this.arm = archString.contains("arm");
        this.arm64 = archString.contains("arm64");
        this.ia64 = archString.contains("ia64");
        this.mips64 = archString.contains("mips64");
        this.ppc64 = archString.contains("ppc64");
        this.s390x = archString.contains("s390x");
        this.mips = archString.contains("mips");
        this.sparc = archString.contains("sparc");
        this.s390 = archString.contains("s390");
    }

    public boolean is64Bit() {
        return this.arm64 || this.amd64 || this.mips64 || this.ppc64 || this.sparc || this.ia64;
    }

    public String toString() {
        return "OSArchitecture{amd64=" + this.amd64 + ", x86=" + this.x86 + ", arm64=" + this.arm64 + ", arm=" + this.arm + ", ia64=" + this.ia64 + ", mips64=" + this.mips64 + ", mips=" + this.mips + ", ppc64=" + this.ppc64 + ", s390x=" + this.s390x + ", sparc=" + this.sparc + ", s390=" + this.s390 + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OSArchitecture that = (OSArchitecture)o;
        return this.amd64 == that.amd64 && this.x86 == that.x86 && this.arm64 == that.arm64 && this.arm == that.arm && this.ia64 == that.ia64 && this.mips64 == that.mips64 && this.mips == that.mips && this.ppc64 == that.ppc64 && this.s390x == that.s390x && this.sparc == that.sparc && this.s390 == that.s390;
    }

    public int hashCode() {
        return Objects.hash(this.amd64, this.x86, this.arm64, this.arm, this.ia64, this.mips64, this.mips, this.ppc64, this.s390x, this.sparc, this.s390);
    }
}

