/*
 * Decompiled with CFR 0.152.
 */
package de.florianmichael.rclasses.common.color;

import java.awt.Color;

public class ColorUtils {
    public static final Color MIN_INT = new Color(Integer.MIN_VALUE, true);
    public static final Color MAX_INT = new Color(Integer.MAX_VALUE, true);

    public static Color withRed(Color color, int red) {
        return new Color(red, color.getGreen(), color.getBlue(), color.getAlpha());
    }

    public static Color withGreen(Color color, int green) {
        return new Color(color.getRed(), green, color.getBlue(), color.getAlpha());
    }

    public static Color withBlue(Color color, int blue) {
        return new Color(color.getRed(), color.getGreen(), blue, color.getAlpha());
    }

    public static Color withAlpha(Color color, int alpha) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), alpha);
    }

    public static Color invert(Color color) {
        return new Color(255 - color.getRed(), 255 - color.getGreen(), 255 - color.getBlue(), color.getAlpha());
    }

    public static String toHex(int color) {
        return String.format("#%06x", color & 0xFFFFFF);
    }

    public static Color fromHex(String hex) {
        return Color.decode(hex);
    }

    public static float[] rgb(int color) {
        return new float[]{(float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f};
    }

    public static float[] rgba(int color) {
        return new float[]{(float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f, (float)(color >> 24 & 0xFF) / 255.0f};
    }

    public static int toSRGB(float[] rgba) {
        return ColorUtils.toSRGB(rgba[0], rgba[1], rgba[2], rgba[3]);
    }

    public static int toSRGB(float r, float g, float b) {
        return ((int)(r * 255.0f) & 0xFF) << 16 | ((int)(g * 255.0f) & 0xFF) << 8 | (int)(b * 255.0f) & 0xFF;
    }

    public static int toSRGB(float r, float g, float b, float a) {
        return ((int)(a * 255.0f) & 0xFF) << 24 | ((int)(r * 255.0f) & 0xFF) << 16 | ((int)(g * 255.0f) & 0xFF) << 8 | (int)(b * 255.0f) & 0xFF;
    }

    public static Color colorInterpolate(Color a, Color b, double t) {
        return ColorUtils.colorInterpolate(a, b, t, t, t, t);
    }

    public static Color colorInterpolate(Color a, Color b, double tR, double tG, double tB, double tA) {
        return new Color((float)(((double)a.getRed() + (double)(b.getRed() - a.getRed()) * tR) / 255.0), (float)(((double)a.getGreen() + (double)(b.getGreen() - a.getGreen()) * tG) / 255.0), (float)(((double)a.getBlue() + (double)(b.getBlue() - a.getBlue()) * tB) / 255.0), (float)(((double)a.getAlpha() + (double)(b.getAlpha() - a.getAlpha()) * tA) / 255.0));
    }

    public static Color getRainbow() {
        return ColorUtils.getRainbow(200L, 0.5);
    }

    public static Color getRainbow(long delay, double time) {
        double rainbowState = Math.ceil(((double)System.currentTimeMillis() * time + (double)delay) / 20.0);
        return Color.getHSBColor((float)((rainbowState %= 360.0) / 360.0), 1.0f, 1.0f);
    }
}

