/*
 * Decompiled with CFR 0.152.
 */
package de.florianmichael.rclasses.common.object;

import de.florianmichael.rclasses.common.StringUtils;
import java.math.BigInteger;
import java.util.UUID;

public class ObjectTypeChecker {
    private static final int DEFAULT_RADIX = 10;
    private static final int MAX_INTEGER_STRING_LENGTH = StringUtils.maximumStringSize(10, Integer.MAX_VALUE);
    private static final int MAX_LONG_STRING_LENGTH = StringUtils.maximumStringSize(10, Long.MAX_VALUE);
    private static final int MAX_SHORT_STRING_LENGTH = StringUtils.maximumStringSize(10, 32767L);
    private static final int MAX_BYTE_STRING_LENGTH = StringUtils.maximumStringSize(10, 127L);

    public static boolean isInteger(String input) {
        if (input.isEmpty() || input.length() > MAX_INTEGER_STRING_LENGTH) {
            return false;
        }
        try {
            Integer.parseInt(input);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static boolean isInteger(String input, int radix) {
        if (input.isEmpty() || input.length() > StringUtils.maximumStringSize(radix, Integer.MAX_VALUE)) {
            return false;
        }
        try {
            Integer.parseInt(input, radix);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static boolean isLong(String input) {
        if (input.isEmpty() || input.length() > MAX_LONG_STRING_LENGTH) {
            return false;
        }
        try {
            Long.parseLong(input);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static boolean isLong(String input, int radix) {
        if (input.isEmpty() || input.length() > StringUtils.maximumStringSize(radix, Long.MAX_VALUE)) {
            return false;
        }
        try {
            Long.parseLong(input, radix);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static boolean isFloat(String input) {
        if (input.isEmpty()) {
            return false;
        }
        try {
            Float.parseFloat(input);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static boolean isDouble(String input) {
        if (input.isEmpty()) {
            return false;
        }
        try {
            Double.parseDouble(input);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static boolean isBoolean(String input) {
        return input.equalsIgnoreCase("true") || input.equalsIgnoreCase("false");
    }

    public static boolean isByte(String input) {
        if (input.isEmpty() || input.length() > MAX_BYTE_STRING_LENGTH) {
            return false;
        }
        try {
            Byte.parseByte(input);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static boolean isByte(String input, int radix) {
        if (input.isEmpty() || input.length() > StringUtils.maximumStringSize(radix, 127L)) {
            return false;
        }
        try {
            Byte.parseByte(input, radix);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static boolean isShort(String input) {
        if (input.isEmpty() || input.length() > MAX_SHORT_STRING_LENGTH) {
            return false;
        }
        try {
            Short.parseShort(input);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static boolean isShort(String input, int radix) {
        if (input.isEmpty() || input.length() > StringUtils.maximumStringSize(radix, 32767L)) {
            return false;
        }
        try {
            Short.parseShort(input, radix);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static boolean isCharacter(String input) {
        return input.length() == 1;
    }

    public static boolean isUUID(String input) {
        if (input.length() != 36) {
            return false;
        }
        try {
            UUID.fromString(input);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static boolean isBigInteger(String input) {
        return ObjectTypeChecker.isBigInteger(input, 10);
    }

    public static boolean isBigInteger(String input, int radix) {
        if (input.isEmpty()) {
            return false;
        }
        try {
            new BigInteger(input, radix);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

