/*
 * Decompiled with CFR 0.152.
 */
package de.florianmichael.rclasses.common.object;

import java.util.Arrays;

public class ObjectArrayWrapper {
    private final Object[] input;

    public ObjectArrayWrapper(Object[] input) {
        this.input = input;
    }

    public int length() {
        return this.input.length;
    }

    public boolean isLength(int length) {
        return this.input.length == length;
    }

    public boolean isSmaller(int length) {
        return this.input.length < length;
    }

    public boolean isSmallerOrEqual(int length) {
        return this.input.length <= length;
    }

    public boolean isGreater(int length) {
        return this.input.length > length;
    }

    public boolean isGreaterOrEqual(int length) {
        return this.input.length >= length;
    }

    public boolean isEmpty() {
        return this.input.length == 0;
    }

    public boolean isIndexValid(int index) {
        return index >= 0 && index < this.input.length;
    }

    public boolean isIndexInvalid(int index) {
        return index < 0 || index >= this.input.length;
    }

    public Object get(int index) {
        if (this.isIndexInvalid(index)) {
            return null;
        }
        return this.input[index];
    }

    public boolean isString(int index) {
        if (this.isIndexInvalid(index)) {
            return false;
        }
        return this.input[index] instanceof String;
    }

    public String getString(int index) {
        if (this.isIndexInvalid(index)) {
            return null;
        }
        return (String)this.input[index];
    }

    public boolean isBoolean(int index) {
        if (this.isIndexInvalid(index)) {
            return false;
        }
        return this.input[index] instanceof Boolean;
    }

    public boolean getBoolean(int index) {
        if (this.isIndexInvalid(index)) {
            return false;
        }
        return (Boolean)this.input[index];
    }

    public boolean isByte(int index) {
        if (this.isIndexInvalid(index)) {
            return false;
        }
        return this.input[index] instanceof Byte;
    }

    public byte getByte(int index) {
        if (this.isIndexInvalid(index)) {
            return 0;
        }
        return (Byte)this.input[index];
    }

    public boolean isShort(int index) {
        if (this.isIndexInvalid(index)) {
            return false;
        }
        return this.input[index] instanceof Short;
    }

    public short getShort(int index) {
        if (this.isIndexInvalid(index)) {
            return 0;
        }
        return (Short)this.input[index];
    }

    public boolean isInteger(int index) {
        if (this.isIndexInvalid(index)) {
            return false;
        }
        return this.input[index] instanceof Integer;
    }

    public int getInteger(int index) {
        if (this.isIndexInvalid(index)) {
            return 0;
        }
        return (Integer)this.input[index];
    }

    public boolean isLong(int index) {
        if (this.isIndexInvalid(index)) {
            return false;
        }
        return this.input[index] instanceof Long;
    }

    public long getLong(int index) {
        if (this.isIndexInvalid(index)) {
            return 0L;
        }
        return (Long)this.input[index];
    }

    public boolean isFloat(int index) {
        if (this.isIndexInvalid(index)) {
            return false;
        }
        return this.input[index] instanceof Float;
    }

    public float getFloat(int index) {
        if (this.isIndexInvalid(index)) {
            return 0.0f;
        }
        return ((Float)this.input[index]).floatValue();
    }

    public boolean isDouble(int index) {
        if (this.isIndexInvalid(index)) {
            return false;
        }
        return this.input[index] instanceof Double;
    }

    public double getDouble(int index) {
        if (this.isIndexInvalid(index)) {
            return 0.0;
        }
        return (Double)this.input[index];
    }

    public boolean isCharacter(int index) {
        if (this.isIndexInvalid(index)) {
            return false;
        }
        return this.input[index] instanceof Character;
    }

    public char getCharacter(int index) {
        if (this.isIndexInvalid(index)) {
            return '\u0000';
        }
        return ((Character)this.input[index]).charValue();
    }

    public Object[] getInput() {
        return this.input;
    }

    public String toString() {
        return "ObjectArrayWrapper{input=" + Arrays.toString(this.input) + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ObjectArrayWrapper that = (ObjectArrayWrapper)o;
        return Arrays.equals(this.input, that.input);
    }

    public int hashCode() {
        return Arrays.hashCode(this.input);
    }

    public static ObjectArrayWrapper createEmpty() {
        return new ObjectArrayWrapper(new Object[0]);
    }
}

