/*
 * Decompiled with CFR 0.152.
 */
package de.florianmichael.rclasses.common.color;

import java.awt.Color;

public class HSBColor {
    public float hue;
    public float saturation;
    public float brightness;
    public float alpha;

    public HSBColor(Color color) {
        float[] hsbColors = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        this.hue = hsbColors[0];
        this.saturation = hsbColors[1];
        this.brightness = hsbColors[2];
        this.alpha = (float)color.getAlpha() / 255.0f;
    }

    public HSBColor(float hue, float saturation, float brightness, float alpha) {
        this.hue = hue;
        this.saturation = saturation;
        this.brightness = brightness;
        this.alpha = alpha;
    }

    public Color getColor() {
        Color color = Color.getHSBColor(this.hue, this.saturation, this.brightness);
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), (int)(this.alpha * 255.0f));
    }

    public void setColor(Color color) {
        float[] hsbColors = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        this.setColor(hsbColors[0], hsbColors[1], hsbColors[2], (float)color.getAlpha() / 255.0f);
    }

    public void setColor(float hue, float saturation, float brightness) {
        this.setColor(hue, saturation, brightness, 1.0f);
    }

    public void setColor(float hue, float saturation, float brightness, float alpha) {
        this.hue = hue;
        this.saturation = saturation;
        this.brightness = brightness;
        this.alpha = alpha;
    }
}

