/*
 * Decompiled with CFR 0.152.
 */
package de.florianmichael.rclasses.common.collection;

import java.util.List;

public class SliceCalculation<T> {
    private final List<T> elements;
    private final int sliceSize;

    public SliceCalculation(List<T> elements, int sliceSize) {
        this.elements = elements;
        this.sliceSize = sliceSize;
    }

    public int getSliceCount() {
        return SliceCalculation.getSliceCount(this.elements.size(), this.sliceSize);
    }

    public List<T> getSlice(int sliceIndex) {
        if (sliceIndex < 0 || sliceIndex >= this.getSliceCount()) {
            throw new IllegalArgumentException("Slice index out of bounds.");
        }
        return this.elements.subList(sliceIndex * this.sliceSize, Math.min((sliceIndex + 1) * this.sliceSize, this.elements.size()));
    }

    public static int getSliceCount(int size, int sliceSize) {
        return (int)Math.ceil((double)size / (double)sliceSize);
    }
}

