/*
 * Decompiled with CFR 0.152.
 */
package de.florianmichael.rclasses.common.collection;

import java.util.Objects;
import java.util.function.IntFunction;

public class ArrayUtils {
    public static boolean[] remove(boolean[] array, int index) {
        int length = array.length - 1;
        boolean[] objs = new boolean[length];
        if (index > 0) {
            System.arraycopy(array, 0, objs, 0, index);
        }
        if (index < array.length - 1) {
            System.arraycopy(array, index + 1, objs, index, array.length - index - 1);
        }
        return objs;
    }

    public static short[] remove(short[] array, int index) {
        int length = array.length - 1;
        short[] objs = new short[length];
        if (index > 0) {
            System.arraycopy(array, 0, objs, 0, index);
        }
        if (index < array.length - 1) {
            System.arraycopy(array, index + 1, objs, index, array.length - index - 1);
        }
        return objs;
    }

    public static int[] remove(int[] array, int index) {
        int length = array.length - 1;
        int[] objs = new int[length];
        if (index > 0) {
            System.arraycopy(array, 0, objs, 0, index);
        }
        if (index < array.length - 1) {
            System.arraycopy(array, index + 1, objs, index, array.length - index - 1);
        }
        return objs;
    }

    public static long[] remove(long[] array, int index) {
        int length = array.length - 1;
        long[] objs = new long[length];
        if (index > 0) {
            System.arraycopy(array, 0, objs, 0, index);
        }
        if (index < array.length - 1) {
            System.arraycopy(array, index + 1, objs, index, array.length - index - 1);
        }
        return objs;
    }

    public static float[] remove(float[] array, int index) {
        int length = array.length - 1;
        float[] objs = new float[length];
        if (index > 0) {
            System.arraycopy(array, 0, objs, 0, index);
        }
        if (index < array.length - 1) {
            System.arraycopy(array, index + 1, objs, index, array.length - index - 1);
        }
        return objs;
    }

    public static double[] remove(double[] array, int index) {
        int length = array.length - 1;
        double[] objs = new double[length];
        if (index > 0) {
            System.arraycopy(array, 0, objs, 0, index);
        }
        if (index < array.length - 1) {
            System.arraycopy(array, index + 1, objs, index, array.length - index - 1);
        }
        return objs;
    }

    public static byte[] remove(byte[] array, int index) {
        int length = array.length - 1;
        byte[] objs = new byte[length];
        if (index > 0) {
            System.arraycopy(array, 0, objs, 0, index);
        }
        if (index < array.length - 1) {
            System.arraycopy(array, index + 1, objs, index, array.length - index - 1);
        }
        return objs;
    }

    public static char[] remove(char[] array, int index) {
        int length = array.length - 1;
        char[] objs = new char[length];
        if (index > 0) {
            System.arraycopy(array, 0, objs, 0, index);
        }
        if (index < array.length - 1) {
            System.arraycopy(array, index + 1, objs, index, array.length - index - 1);
        }
        return objs;
    }

    public static <T> T[] remove(T[] array, int index, IntFunction<T[]> factory) {
        int length = array.length - 1;
        T[] objs = factory.apply(length);
        if (index > 0) {
            System.arraycopy(array, 0, objs, 0, index);
        }
        if (index < array.length - 1) {
            System.arraycopy(array, index + 1, objs, index, array.length - index - 1);
        }
        return objs;
    }

    public static boolean[] add(boolean[] array, boolean adding) {
        int length = array.length + 1;
        boolean[] objs = new boolean[length];
        System.arraycopy(array, 0, objs, 0, array.length);
        objs[length - 1] = adding;
        return objs;
    }

    public static short[] add(short[] array, short adding) {
        int length = array.length + 1;
        short[] objs = new short[length];
        System.arraycopy(array, 0, objs, 0, array.length);
        objs[length - 1] = adding;
        return objs;
    }

    public static int[] add(int[] array, int adding) {
        int length = array.length + 1;
        int[] objs = new int[length];
        System.arraycopy(array, 0, objs, 0, array.length);
        objs[length - 1] = adding;
        return objs;
    }

    public static long[] add(long[] array, long adding) {
        int length = array.length + 1;
        long[] objs = new long[length];
        System.arraycopy(array, 0, objs, 0, array.length);
        objs[length - 1] = adding;
        return objs;
    }

    public static float[] add(float[] array, float adding) {
        int length = array.length + 1;
        float[] objs = new float[length];
        System.arraycopy(array, 0, objs, 0, array.length);
        objs[length - 1] = adding;
        return objs;
    }

    public static double[] add(double[] array, double adding) {
        int length = array.length + 1;
        double[] objs = new double[length];
        System.arraycopy(array, 0, objs, 0, array.length);
        objs[length - 1] = adding;
        return objs;
    }

    public static byte[] add(byte[] array, byte adding) {
        int length = array.length + 1;
        byte[] objs = new byte[length];
        System.arraycopy(array, 0, objs, 0, array.length);
        objs[length - 1] = adding;
        return objs;
    }

    public static char[] add(char[] array, char adding) {
        int length = array.length + 1;
        char[] objs = new char[length];
        System.arraycopy(array, 0, objs, 0, array.length);
        objs[length - 1] = adding;
        return objs;
    }

    public static boolean[] add(boolean[] array, int index, boolean adding) {
        index = Math.max(0, Math.min(array.length - 1, index));
        boolean[] objs = new boolean[array.length + 1];
        objs[index] = adding;
        System.arraycopy(array, 0, objs, 0, index);
        System.arraycopy(array, index, objs, index + 1, array.length - index);
        return objs;
    }

    public static short[] add(short[] array, int index, short adding) {
        index = Math.max(0, Math.min(array.length - 1, index));
        short[] objs = new short[array.length + 1];
        objs[index] = adding;
        System.arraycopy(array, 0, objs, 0, index);
        System.arraycopy(array, index, objs, index + 1, array.length - index);
        return objs;
    }

    public static int[] add(int[] array, int index, int adding) {
        index = Math.max(0, Math.min(array.length - 1, index));
        int[] objs = new int[array.length + 1];
        objs[index] = adding;
        System.arraycopy(array, 0, objs, 0, index);
        System.arraycopy(array, index, objs, index + 1, array.length - index);
        return objs;
    }

    public static long[] add(long[] array, int index, long adding) {
        index = Math.max(0, Math.min(array.length - 1, index));
        long[] objs = new long[array.length + 1];
        objs[index] = adding;
        System.arraycopy(array, 0, objs, 0, index);
        System.arraycopy(array, index, objs, index + 1, array.length - index);
        return objs;
    }

    public static float[] add(float[] array, int index, float adding) {
        index = Math.max(0, Math.min(array.length - 1, index));
        float[] objs = new float[array.length + 1];
        objs[index] = adding;
        System.arraycopy(array, 0, objs, 0, index);
        System.arraycopy(array, index, objs, index + 1, array.length - index);
        return objs;
    }

    public static double[] add(double[] array, int index, double adding) {
        index = Math.max(0, Math.min(array.length - 1, index));
        double[] objs = new double[array.length + 1];
        objs[index] = adding;
        System.arraycopy(array, 0, objs, 0, index);
        System.arraycopy(array, index, objs, index + 1, array.length - index);
        return objs;
    }

    public static byte[] add(byte[] array, int index, byte adding) {
        index = Math.max(0, Math.min(array.length - 1, index));
        byte[] objs = new byte[array.length + 1];
        objs[index] = adding;
        System.arraycopy(array, 0, objs, 0, index);
        System.arraycopy(array, index, objs, index + 1, array.length - index);
        return objs;
    }

    public static char[] add(char[] array, int index, char adding) {
        index = Math.max(0, Math.min(array.length - 1, index));
        char[] objs = new char[array.length + 1];
        objs[index] = adding;
        System.arraycopy(array, 0, objs, 0, index);
        System.arraycopy(array, index, objs, index + 1, array.length - index);
        return objs;
    }

    public static <T> T[] add(T[] array, T adding, IntFunction<T[]> factory) {
        int length = array.length + 1;
        T[] objs = factory.apply(length);
        System.arraycopy(array, 0, objs, 0, array.length);
        objs[length - 1] = adding;
        return objs;
    }

    public static <T> T[] add(T[] array, int index, T adding, IntFunction<T[]> factory) {
        index = Math.max(0, Math.min(array.length - 1, index));
        T[] objs = factory.apply(array.length + 1);
        objs[index] = adding;
        System.arraycopy(array, 0, objs, 0, index);
        System.arraycopy(array, index, objs, index + 1, array.length - index);
        return objs;
    }

    public static boolean[] sub(boolean[] array, int start, int end) {
        int min = Math.min(start, end);
        int max = Math.max(start, end);
        if (min == array.length || array.length <= 1) {
            return (boolean[])array.clone();
        }
        int length = max - min + 1;
        boolean[] objs = new boolean[length];
        System.arraycopy(array, min, objs, 0, length);
        return objs;
    }

    public static short[] sub(short[] array, int start, int end) {
        int min = Math.min(start, end);
        int max = Math.max(start, end);
        if (min == array.length || array.length <= 1) {
            return (short[])array.clone();
        }
        int length = max - min + 1;
        short[] objs = new short[length];
        System.arraycopy(array, min, objs, 0, length);
        return objs;
    }

    public static int[] sub(int[] array, int start, int end) {
        int min = Math.min(start, end);
        int max = Math.max(start, end);
        if (min == array.length || array.length <= 1) {
            return (int[])array.clone();
        }
        int length = max - min + 1;
        int[] objs = new int[length];
        System.arraycopy(array, min, objs, 0, length);
        return objs;
    }

    public static long[] sub(long[] array, int start, int end) {
        int min = Math.min(start, end);
        int max = Math.max(start, end);
        if (min == array.length || array.length <= 1) {
            return (long[])array.clone();
        }
        int length = max - min + 1;
        long[] objs = new long[length];
        System.arraycopy(array, min, objs, 0, length);
        return objs;
    }

    public static float[] sub(float[] array, int start, int end) {
        int min = Math.min(start, end);
        int max = Math.max(start, end);
        if (min == array.length || array.length <= 1) {
            return (float[])array.clone();
        }
        int length = max - min + 1;
        float[] objs = new float[length];
        System.arraycopy(array, min, objs, 0, length);
        return objs;
    }

    public static double[] sub(double[] array, int start, int end) {
        int min = Math.min(start, end);
        int max = Math.max(start, end);
        if (min == array.length || array.length <= 1) {
            return (double[])array.clone();
        }
        int length = max - min + 1;
        double[] objs = new double[length];
        System.arraycopy(array, min, objs, 0, length);
        return objs;
    }

    public static byte[] sub(byte[] array, int start, int end) {
        int min = Math.min(start, end);
        int max = Math.max(start, end);
        if (min == array.length || array.length <= 1) {
            return (byte[])array.clone();
        }
        int length = max - min + 1;
        byte[] objs = new byte[length];
        System.arraycopy(array, min, objs, 0, length);
        return objs;
    }

    public static char[] sub(char[] array, int start, int end) {
        int min = Math.min(start, end);
        int max = Math.max(start, end);
        if (min == array.length || array.length <= 1) {
            return (char[])array.clone();
        }
        int length = max - min + 1;
        char[] objs = new char[length];
        System.arraycopy(array, min, objs, 0, length);
        return objs;
    }

    public static <T> T[] sub(T[] array, int start, int end, IntFunction<T[]> factory) {
        int min = Math.min(start, end);
        int max = Math.max(start, end);
        if (min == array.length || array.length <= 1) {
            return (Object[])array.clone();
        }
        int length = max - min + 1;
        T[] objs = factory.apply(length);
        System.arraycopy(array, min, objs, 0, length);
        return objs;
    }

    public static boolean[] merge(boolean[] array1, boolean[] array2) {
        boolean[] objs = new boolean[array1.length + array2.length];
        System.arraycopy(array1, 0, objs, 0, array1.length);
        System.arraycopy(array2, 0, objs, array1.length, array2.length);
        return objs;
    }

    public static short[] merge(short[] array1, short[] array2) {
        short[] objs = new short[array1.length + array2.length];
        System.arraycopy(array1, 0, objs, 0, array1.length);
        System.arraycopy(array2, 0, objs, array1.length, array2.length);
        return objs;
    }

    public static int[] merge(int[] array1, int[] array2) {
        int[] objs = new int[array1.length + array2.length];
        System.arraycopy(array1, 0, objs, 0, array1.length);
        System.arraycopy(array2, 0, objs, array1.length, array2.length);
        return objs;
    }

    public static long[] merge(long[] array1, long[] array2) {
        long[] objs = new long[array1.length + array2.length];
        System.arraycopy(array1, 0, objs, 0, array1.length);
        System.arraycopy(array2, 0, objs, array1.length, array2.length);
        return objs;
    }

    public static float[] merge(float[] array1, float[] array2) {
        float[] objs = new float[array1.length + array2.length];
        System.arraycopy(array1, 0, objs, 0, array1.length);
        System.arraycopy(array2, 0, objs, array1.length, array2.length);
        return objs;
    }

    public static double[] merge(double[] array1, double[] array2) {
        double[] objs = new double[array1.length + array2.length];
        System.arraycopy(array1, 0, objs, 0, array1.length);
        System.arraycopy(array2, 0, objs, array1.length, array2.length);
        return objs;
    }

    public static byte[] merge(byte[] array1, byte[] array2) {
        byte[] objs = new byte[array1.length + array2.length];
        System.arraycopy(array1, 0, objs, 0, array1.length);
        System.arraycopy(array2, 0, objs, array1.length, array2.length);
        return objs;
    }

    public static char[] merge(char[] array1, char[] array2) {
        char[] objs = new char[array1.length + array2.length];
        System.arraycopy(array1, 0, objs, 0, array1.length);
        System.arraycopy(array2, 0, objs, array1.length, array2.length);
        return objs;
    }

    public static <T> T[] merge(T[] array1, T[] array2, IntFunction<T[]> factory) {
        T[] objs = factory.apply(array1.length + array2.length);
        System.arraycopy(array1, 0, objs, 0, array1.length);
        System.arraycopy(array2, 0, objs, array1.length, array2.length);
        return objs;
    }

    public static boolean[] merge(boolean[][] array, IntFunction<boolean[]> factory) {
        int length = 0;
        for (boolean[] objects : array) {
            length += objects.length;
        }
        boolean[] objs = factory.apply(length);
        int index = 0;
        for (boolean[] objects : array) {
            System.arraycopy(objects, 0, objs, index, objects.length);
            index += objects.length;
        }
        return objs;
    }

    public static short[] merge(short[][] array, IntFunction<short[]> factory) {
        int length = 0;
        for (short[] objects : array) {
            length += objects.length;
        }
        short[] objs = factory.apply(length);
        int index = 0;
        for (short[] objects : array) {
            System.arraycopy(objects, 0, objs, index, objects.length);
            index += objects.length;
        }
        return objs;
    }

    public static int[] merge(int[][] array, IntFunction<int[]> factory) {
        int length = 0;
        for (int[] objects : array) {
            length += objects.length;
        }
        int[] objs = factory.apply(length);
        int index = 0;
        for (int[] objects : array) {
            System.arraycopy(objects, 0, objs, index, objects.length);
            index += objects.length;
        }
        return objs;
    }

    public static long[] merge(long[][] array, IntFunction<long[]> factory) {
        int length = 0;
        for (long[] objects : array) {
            length += objects.length;
        }
        long[] objs = factory.apply(length);
        int index = 0;
        for (long[] objects : array) {
            System.arraycopy(objects, 0, objs, index, objects.length);
            index += objects.length;
        }
        return objs;
    }

    public static float[] merge(float[][] array, IntFunction<float[]> factory) {
        int length = 0;
        for (float[] objects : array) {
            length += objects.length;
        }
        float[] objs = factory.apply(length);
        int index = 0;
        for (float[] objects : array) {
            System.arraycopy(objects, 0, objs, index, objects.length);
            index += objects.length;
        }
        return objs;
    }

    public static double[] merge(double[][] array, IntFunction<double[]> factory) {
        int length = 0;
        for (double[] objects : array) {
            length += objects.length;
        }
        double[] objs = factory.apply(length);
        int index = 0;
        for (double[] objects : array) {
            System.arraycopy(objects, 0, objs, index, objects.length);
            index += objects.length;
        }
        return objs;
    }

    public static byte[] merge(byte[][] array, IntFunction<byte[]> factory) {
        int length = 0;
        for (byte[] objects : array) {
            length += objects.length;
        }
        byte[] objs = factory.apply(length);
        int index = 0;
        for (byte[] objects : array) {
            System.arraycopy(objects, 0, objs, index, objects.length);
            index += objects.length;
        }
        return objs;
    }

    public static char[] merge(char[][] array, IntFunction<char[]> factory) {
        int length = 0;
        for (char[] objects : array) {
            length += objects.length;
        }
        char[] objs = factory.apply(length);
        int index = 0;
        for (char[] objects : array) {
            System.arraycopy(objects, 0, objs, index, objects.length);
            index += objects.length;
        }
        return objs;
    }

    public static <T> T[] merge(T[][] array, IntFunction<T[]> factory) {
        int length = 0;
        for (T[] objects : array) {
            length += objects.length;
        }
        T[] objs = factory.apply(length);
        int index = 0;
        for (T[] objects : array) {
            System.arraycopy(objects, 0, objs, index, objects.length);
            index += objects.length;
        }
        return objs;
    }

    public static boolean[] reverse(boolean[] array) {
        if (array.length <= 1) {
            return array;
        }
        boolean[] objs = new boolean[array.length];
        int index = 0;
        for (int i = Math.max(objs.length - 1, 0); i >= 0; --i) {
            objs[index++] = array[i];
        }
        return objs;
    }

    public static short[] reverse(short[] array) {
        if (array.length <= 1) {
            return array;
        }
        short[] objs = new short[array.length];
        int index = 0;
        for (int i = Math.max(objs.length - 1, 0); i >= 0; --i) {
            objs[index++] = array[i];
        }
        return objs;
    }

    public static int[] reverse(int[] array) {
        if (array.length <= 1) {
            return array;
        }
        int[] objs = new int[array.length];
        int index = 0;
        for (int i = Math.max(objs.length - 1, 0); i >= 0; --i) {
            objs[index++] = array[i];
        }
        return objs;
    }

    public static long[] reverse(long[] array) {
        if (array.length <= 1) {
            return array;
        }
        long[] objs = new long[array.length];
        int index = 0;
        for (int i = Math.max(objs.length - 1, 0); i >= 0; --i) {
            objs[index++] = array[i];
        }
        return objs;
    }

    public static float[] reverse(float[] array) {
        if (array.length <= 1) {
            return array;
        }
        float[] objs = new float[array.length];
        int index = 0;
        for (int i = Math.max(objs.length - 1, 0); i >= 0; --i) {
            objs[index++] = array[i];
        }
        return objs;
    }

    public static double[] reverse(double[] array) {
        if (array.length <= 1) {
            return array;
        }
        double[] objs = new double[array.length];
        int index = 0;
        for (int i = Math.max(objs.length - 1, 0); i >= 0; --i) {
            objs[index++] = array[i];
        }
        return objs;
    }

    public static byte[] reverse(byte[] array) {
        if (array.length <= 1) {
            return array;
        }
        byte[] objs = new byte[array.length];
        int index = 0;
        for (int i = Math.max(objs.length - 1, 0); i >= 0; --i) {
            objs[index++] = array[i];
        }
        return objs;
    }

    public static char[] reverse(char[] array) {
        if (array.length <= 1) {
            return array;
        }
        char[] objs = new char[array.length];
        int index = 0;
        for (int i = Math.max(objs.length - 1, 0); i >= 0; --i) {
            objs[index++] = array[i];
        }
        return objs;
    }

    public static <T> T[] reverse(T[] array, IntFunction<T[]> factory) {
        if (array.length <= 1) {
            return array;
        }
        T[] objs = factory.apply(array.length);
        int index = 0;
        for (int i = Math.max(objs.length - 1, 0); i >= 0; --i) {
            objs[index++] = array[i];
        }
        return objs;
    }

    public static int indexOf(boolean[] array, boolean find) {
        return ArrayUtils.indexOf(array, find, 0);
    }

    public static int indexOf(boolean[] array, boolean find, int startIndex) {
        if (array.length == 0) {
            return -1;
        }
        for (int i = startIndex; i < array.length; ++i) {
            if (!Objects.equals(find, array[i])) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(short[] array, short find) {
        return ArrayUtils.indexOf(array, find, 0);
    }

    public static int indexOf(short[] array, short find, int startIndex) {
        if (array.length == 0) {
            return -1;
        }
        for (int i = startIndex; i < array.length; ++i) {
            if (!Objects.equals(find, array[i])) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(int[] array, int find) {
        return ArrayUtils.indexOf(array, find, 0);
    }

    public static int indexOf(int[] array, int find, int startIndex) {
        if (array.length == 0) {
            return -1;
        }
        for (int i = startIndex; i < array.length; ++i) {
            if (!Objects.equals(find, array[i])) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(long[] array, long find) {
        return ArrayUtils.indexOf(array, find, 0);
    }

    public static int indexOf(long[] array, long find, int startIndex) {
        if (array.length == 0) {
            return -1;
        }
        for (int i = startIndex; i < array.length; ++i) {
            if (!Objects.equals(find, array[i])) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(float[] array, float find) {
        return ArrayUtils.indexOf(array, find, 0);
    }

    public static int indexOf(float[] array, float find, int startIndex) {
        if (array.length == 0) {
            return -1;
        }
        for (int i = startIndex; i < array.length; ++i) {
            if (!Objects.equals(Float.valueOf(find), Float.valueOf(array[i]))) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(double[] array, double find) {
        return ArrayUtils.indexOf(array, find, 0);
    }

    public static int indexOf(double[] array, double find, int startIndex) {
        if (array.length == 0) {
            return -1;
        }
        for (int i = startIndex; i < array.length; ++i) {
            if (!Objects.equals(find, array[i])) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(byte[] array, byte find) {
        return ArrayUtils.indexOf(array, find, 0);
    }

    public static int indexOf(byte[] array, byte find, int startIndex) {
        if (array.length == 0) {
            return -1;
        }
        for (int i = startIndex; i < array.length; ++i) {
            if (!Objects.equals(find, array[i])) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(char[] array, char find) {
        return ArrayUtils.indexOf(array, find, 0);
    }

    public static int indexOf(char[] array, char find, int startIndex) {
        if (array.length == 0) {
            return -1;
        }
        for (int i = startIndex; i < array.length; ++i) {
            if (!Objects.equals(Character.valueOf(find), Character.valueOf(array[i]))) continue;
            return i;
        }
        return -1;
    }

    public static <T> int indexOf(T[] array, T find) {
        return ArrayUtils.indexOf(array, find, 0);
    }

    public static <T> int indexOf(T[] array, T find, int startIndex) {
        if (array.length == 0) {
            return -1;
        }
        for (int i = startIndex; i < array.length; ++i) {
            if (!Objects.equals(find, array[i])) continue;
            return i;
        }
        return -1;
    }

    public static int[] indicesOf(boolean[] array, boolean find) {
        return ArrayUtils.indicesOf(array, find, 0);
    }

    public static int[] indicesOf(boolean[] array, boolean find, int startIndex) {
        if (array.length == 0) {
            return new int[0];
        }
        int[] indices = new int[]{};
        for (int i = startIndex; i < array.length; ++i) {
            if (!Objects.equals(find, array[i])) continue;
            indices = ArrayUtils.add(indices, i);
        }
        return indices;
    }

    public static int[] indicesOf(short[] array, short find) {
        return ArrayUtils.indicesOf(array, find, 0);
    }

    public static int[] indicesOf(short[] array, short find, int startIndex) {
        if (array.length == 0) {
            return new int[0];
        }
        int[] indices = new int[]{};
        for (int i = startIndex; i < array.length; ++i) {
            if (!Objects.equals(find, array[i])) continue;
            indices = ArrayUtils.add(indices, i);
        }
        return indices;
    }

    public static int[] indicesOf(int[] array, int find) {
        return ArrayUtils.indicesOf(array, find, 0);
    }

    public static int[] indicesOf(int[] array, int find, int startIndex) {
        if (array.length == 0) {
            return new int[0];
        }
        int[] indices = new int[]{};
        for (int i = startIndex; i < array.length; ++i) {
            if (!Objects.equals(find, array[i])) continue;
            indices = ArrayUtils.add(indices, i);
        }
        return indices;
    }

    public static int[] indicesOf(long[] array, long find) {
        return ArrayUtils.indicesOf(array, find, 0);
    }

    public static int[] indicesOf(long[] array, long find, int startIndex) {
        if (array.length == 0) {
            return new int[0];
        }
        int[] indices = new int[]{};
        for (int i = startIndex; i < array.length; ++i) {
            if (!Objects.equals(find, array[i])) continue;
            indices = ArrayUtils.add(indices, i);
        }
        return indices;
    }

    public static int[] indicesOf(float[] array, float find) {
        return ArrayUtils.indicesOf(array, find, 0);
    }

    public static int[] indicesOf(float[] array, float find, int startIndex) {
        if (array.length == 0) {
            return new int[0];
        }
        int[] indices = new int[]{};
        for (int i = startIndex; i < array.length; ++i) {
            if (!Objects.equals(Float.valueOf(find), Float.valueOf(array[i]))) continue;
            indices = ArrayUtils.add(indices, i);
        }
        return indices;
    }

    public static int[] indicesOf(double[] array, double find) {
        return ArrayUtils.indicesOf(array, find, 0);
    }

    public static int[] indicesOf(double[] array, double find, int startIndex) {
        if (array.length == 0) {
            return new int[0];
        }
        int[] indices = new int[]{};
        for (int i = startIndex; i < array.length; ++i) {
            if (!Objects.equals(find, array[i])) continue;
            indices = ArrayUtils.add(indices, i);
        }
        return indices;
    }

    public static int[] indicesOf(byte[] array, byte find) {
        return ArrayUtils.indicesOf(array, find, 0);
    }

    public static int[] indicesOf(byte[] array, byte find, int startIndex) {
        if (array.length == 0) {
            return new int[0];
        }
        int[] indices = new int[]{};
        for (int i = startIndex; i < array.length; ++i) {
            if (!Objects.equals(find, array[i])) continue;
            indices = ArrayUtils.add(indices, i);
        }
        return indices;
    }

    public static int[] indicesOf(char[] array, char find) {
        return ArrayUtils.indicesOf(array, find, 0);
    }

    public static int[] indicesOf(char[] array, char find, int startIndex) {
        if (array.length == 0) {
            return new int[0];
        }
        int[] indices = new int[]{};
        for (int i = startIndex; i < array.length; ++i) {
            if (!Objects.equals(Character.valueOf(find), Character.valueOf(array[i]))) continue;
            indices = ArrayUtils.add(indices, i);
        }
        return indices;
    }

    public static <T> int[] indicesOf(T[] array, T find) {
        return ArrayUtils.indicesOf(array, find, 0);
    }

    public static <T> int[] indicesOf(T[] array, T find, int startIndex) {
        if (array.length == 0) {
            return new int[0];
        }
        int[] indices = new int[]{};
        for (int i = startIndex; i < array.length; ++i) {
            if (!Objects.equals(find, array[i])) continue;
            indices = ArrayUtils.add(indices, i);
        }
        return indices;
    }

    public static boolean contains(boolean[] array, boolean value) {
        for (boolean obj : array) {
            if (!Objects.equals(obj, value)) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(short[] array, short value) {
        for (short obj : array) {
            if (!Objects.equals(obj, value)) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(int[] array, int value) {
        for (int obj : array) {
            if (!Objects.equals(obj, value)) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(long[] array, long value) {
        for (long obj : array) {
            if (!Objects.equals(obj, value)) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(float[] array, float value) {
        for (float obj : array) {
            if (!Objects.equals(Float.valueOf(obj), Float.valueOf(value))) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(double[] array, double value) {
        for (double obj : array) {
            if (!Objects.equals(obj, value)) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(byte[] array, byte value) {
        for (byte obj : array) {
            if (!Objects.equals(obj, value)) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(char[] array, char value) {
        for (char obj : array) {
            if (!Objects.equals(Character.valueOf(obj), Character.valueOf(value))) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean contains(T[] array, T value) {
        for (T obj : array) {
            if (!Objects.equals(obj, value)) continue;
            return true;
        }
        return false;
    }
}

