/*
 * Decompiled with CFR 0.152.
 */
package de.florianmichael.rclasses.common;

import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;

public final class StringUtils {
    public static final String UPPER_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    public static final String LOWER_CHARS = "abdcefghijklmnopqrstuvwxyz";
    public static final String SPECIAL_CHARS = "!@#$%&*()_+-=[]|,./?><";
    public static final String NUMBER_CHARS = "0123456789";
    public static final List<String> ESCAPED_CHARACTERS = Arrays.asList("\t", "\b", "\n", "\r");
    private static final String[] BYTES_UNIT = new String[]{"B", "KiB", "MiB", "GiB", "TiB"};
    private static final DecimalFormat OPTIONAL_FORMAT = new DecimalFormat("#.##");

    public static String formatBytes(long value) {
        int index = (int)(Math.log(value) / Math.log(1024.0));
        double data = (double)value / Math.pow(1024.0, index);
        if (index < 0) {
            index = 0;
        }
        if (Double.isNaN(data)) {
            data = 0.0;
        }
        return OPTIONAL_FORMAT.format(data) + " " + BYTES_UNIT[index];
    }

    public static String uppercaseFirst(String string) {
        if (string.length() < 2) {
            return string;
        }
        return string.substring(0, 1).toUpperCase() + string.substring(1).toLowerCase();
    }

    public static String reverse(String string) {
        char[] characters = string.toCharArray();
        char[] reversed = new char[characters.length];
        for (int i = 0; i < characters.length; ++i) {
            reversed[i] = characters[characters.length - i - 1];
        }
        return new String(reversed);
    }

    public static String whitespace(int count) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            builder.append("\t");
        }
        return builder.toString();
    }

    public static String space(int count) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            builder.append(" ");
        }
        return builder.toString();
    }

    public static String longestOf(List<String> strings) {
        return StringUtils.longestOf(strings.toArray(new String[0]));
    }

    public static String longestOf(String ... strings) {
        String longestString = "";
        int max = 0;
        for (String string : strings) {
            if (string.length() <= max) continue;
            longestString = string;
            max = longestString.length();
        }
        return longestString;
    }

    public static String smallestOf(List<String> strings) {
        return StringUtils.smallestOf(strings.toArray(new String[0]));
    }

    public static String smallestOf(String ... strings) {
        String smallestString = "";
        long min = Long.MAX_VALUE;
        for (String string : strings) {
            if ((long)string.length() >= min) continue;
            smallestString = string;
            min = smallestString.length();
        }
        return smallestString;
    }

    public static String normalizeEnumName(String string) {
        if (string.length() < 2) {
            return string;
        }
        string = string.replace("_", " ");
        string = string.replace("$", "");
        return string.charAt(0) + string.substring(1).toLowerCase();
    }

    public static String replaceLast(String string, String target, String replacement) {
        if (string == null || target == null || replacement == null) {
            return string;
        }
        return string.replaceFirst("(?s)(.*)" + target, "$1" + replacement);
    }

    public static String replaceAll(String string, String sequence, String replacement) {
        if (string == null || sequence == null || replacement == null) {
            return string;
        }
        return Pattern.compile(sequence, 2).matcher(string).replaceAll(replacement);
    }

    public static boolean contains(String string, String sequence) {
        if (string == null || sequence == null) {
            return false;
        }
        return string.toLowerCase().contains(sequence.toLowerCase());
    }

    public static boolean endsWith(String string, String suffix) {
        if (string == null || suffix == null) {
            return false;
        }
        return string.toLowerCase().endsWith(suffix.toLowerCase());
    }

    public static boolean startsWith(String input, String prefix) {
        if (input == null || prefix == null) {
            return false;
        }
        return input.toLowerCase().startsWith(prefix.toLowerCase());
    }

    public static int maximumStringSize(int radix, long maxValue) {
        return (int)Math.ceil(Math.log(maxValue) / Math.log(radix)) + 1;
    }
}

