/*
 * Decompiled with CFR 0.152.
 */
package de.florianmichael.classic4j.util;

import de.florianmichael.classic4j.util.model.CookieStore;
import de.florianmichael.classic4j.util.model.Parameter;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;

public class WebUtils {
    public static final HttpClient HTTP_CLIENT = HttpClient.newHttpClient();

    public static String createRequestBody(Parameter ... parameters) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < parameters.length; ++i) {
            Parameter parameter = parameters[i];
            if (parameter.name() == null || parameter.value() == null) continue;
            builder.append(parameter.name()).append("=").append(URLEncoder.encode(parameter.value(), StandardCharsets.UTF_8));
            if (i == parameters.length - 1) continue;
            builder.append("&");
        }
        return builder.toString();
    }

    public static HttpRequest buildWithCookies(CookieStore cookieStore, HttpRequest.Builder builder) {
        return cookieStore.appendCookies(builder).build();
    }

    public static void updateCookies(CookieStore cookieStore, HttpResponse<?> response) {
        cookieStore.mergeFromResponse(response);
    }
}

