/*
 * Decompiled with CFR 0.152.
 */
package de.florianmichael.classic4j.request.classicube.server;

import de.florianmichael.classic4j.ClassiCubeHandler;
import de.florianmichael.classic4j.model.classicube.account.CCAccount;
import de.florianmichael.classic4j.model.classicube.server.CCServerList;
import de.florianmichael.classic4j.util.WebUtils;
import java.net.URI;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class CCServerInfoRequest {
    private static URI generateUri(List<String> serverHashes) {
        String joined = String.join((CharSequence)",", serverHashes);
        return ClassiCubeHandler.SERVER_INFO_URI.resolve(joined);
    }

    public static CompletableFuture<CCServerList> send(CCAccount account, List<String> serverHashes) {
        return CompletableFuture.supplyAsync(() -> {
            URI uri = CCServerInfoRequest.generateUri(serverHashes);
            HttpRequest request = WebUtils.buildWithCookies(account.cookieStore, HttpRequest.newBuilder().GET().uri(uri));
            HttpResponse<String> response = WebUtils.HTTP_CLIENT.sendAsync(request, HttpResponse.BodyHandlers.ofString()).join();
            WebUtils.updateCookies(account.cookieStore, response);
            String body = response.body();
            return CCServerList.fromJson(body);
        });
    }
}

