/*
 * Decompiled with CFR 0.152.
 */
package de.florianmichael.classic4j;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import de.florianmichael.classic4j.api.LoginProcessHandler;
import de.florianmichael.classic4j.model.classicube.account.CCAccount;
import de.florianmichael.classic4j.model.classicube.server.CCServerList;
import de.florianmichael.classic4j.request.classicube.auth.CCAuthenticationLoginRequest;
import de.florianmichael.classic4j.request.classicube.auth.CCAuthenticationTokenRequest;
import de.florianmichael.classic4j.request.classicube.server.CCServerInfoRequest;
import de.florianmichael.classic4j.request.classicube.server.CCServerListRequest;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import javax.security.auth.login.LoginException;

public class ClassiCubeHandler {
    public static final Gson GSON = new GsonBuilder().serializeNulls().create();
    public static final URI CLASSICUBE_ROOT_URI = URI.create("https://www.classicube.net");
    public static final URI AUTHENTICATION_URI = CLASSICUBE_ROOT_URI.resolve("/api/login/");
    public static final URI SERVER_INFO_URI = CLASSICUBE_ROOT_URI.resolve("/api/server/");
    public static final URI SERVER_LIST_INFO_URI = CLASSICUBE_ROOT_URI.resolve("/api/servers/");

    public static void requestServerList(CCAccount account, Consumer<CCServerList> complete) {
        ClassiCubeHandler.requestServerList(account, complete, Throwable::printStackTrace);
    }

    public static void requestServerList(CCAccount account, Consumer<CCServerList> complete, Consumer<Throwable> throwableConsumer) {
        CCServerListRequest.send(account).whenComplete((ccServerList, throwable) -> {
            if (throwable != null) {
                throwableConsumer.accept((Throwable)throwable);
                return;
            }
            complete.accept((CCServerList)ccServerList);
        });
    }

    public static void requestServerInfo(CCAccount account, String serverHash, Consumer<CCServerList> complete) {
        ClassiCubeHandler.requestServerInfo(account, serverHash, complete, Throwable::printStackTrace);
    }

    public static void requestServerInfo(CCAccount account, String serverHash, Consumer<CCServerList> complete, Consumer<Throwable> throwableConsumer) {
        ClassiCubeHandler.requestServerInfo(account, Collections.singletonList(serverHash), complete, throwableConsumer);
    }

    public static void requestServerInfo(CCAccount account, List<String> serverHashes, Consumer<CCServerList> complete) {
        ClassiCubeHandler.requestServerInfo(account, serverHashes, complete, Throwable::printStackTrace);
    }

    public static void requestServerInfo(CCAccount account, List<String> serverHashes, Consumer<CCServerList> complete, Consumer<Throwable> throwableConsumer) {
        CCServerInfoRequest.send(account, serverHashes).whenComplete((ccServerList, throwable) -> {
            if (throwable != null) {
                throwableConsumer.accept((Throwable)throwable);
                return;
            }
            complete.accept((CCServerList)ccServerList);
        });
    }

    public static void requestAuthentication(CCAccount account, String loginCode, LoginProcessHandler processHandler) {
        CCAuthenticationTokenRequest.send(account).whenComplete((initialTokenResponse, throwable) -> {
            if (throwable != null) {
                processHandler.handleException((Throwable)throwable);
                return;
            }
            if (initialTokenResponse.shouldError()) {
                String errorDisplay = initialTokenResponse.getErrorDisplay();
                processHandler.handleException(new LoginException(errorDisplay));
                return;
            }
            account.token = initialTokenResponse.token;
            CCAuthenticationLoginRequest.send(account, initialTokenResponse, loginCode).whenComplete((loginResponse, throwable1) -> {
                if (throwable1 != null) {
                    processHandler.handleException((Throwable)throwable1);
                    return;
                }
                if (loginResponse.mfaRequired()) {
                    processHandler.handleMfa(account);
                    return;
                }
                if (loginResponse.shouldError()) {
                    String errorDisplay = loginResponse.getErrorDisplay();
                    processHandler.handleException(new LoginException(errorDisplay));
                    return;
                }
                processHandler.handleSuccessfulLogin(account);
            });
        });
    }
}

