/*
 * Decompiled with CFR 0.152.
 */
package de.florianmichael.brainfuck4j.memory.impl;

import de.florianmichael.brainfuck4j.language.InstructionTypes;
import de.florianmichael.brainfuck4j.memory.AMemory;
import java.io.InputStreamReader;
import java.io.PrintStream;

public class ByteMemory
extends AMemory {
    private final byte[] memory;

    public ByteMemory(int size) {
        super(size);
        this.memory = new byte[size];
    }

    @Override
    public int handleInstruction(InputStreamReader in, PrintStream out, InstructionTypes type, int count, int index, short[] loopPoints) throws Throwable {
        if (type == InstructionTypes.INCREASE_VALUE) {
            int n = this.currentPointer;
            this.memory[n] = (byte)(this.memory[n] + (byte)count);
        } else if (type == InstructionTypes.DECREASE_VALUE) {
            int n = this.currentPointer;
            this.memory[n] = (byte)(this.memory[n] - (byte)count);
        } else if (type == InstructionTypes.START_LOOP) {
            if (this.memory[this.currentPointer] == 0) {
                return loopPoints[index];
            }
        } else if (type == InstructionTypes.END_LOOP) {
            if (this.memory[this.currentPointer] != 0) {
                return loopPoints[index];
            }
        } else if (type == InstructionTypes.GET_CHAR) {
            out.write(this.memory[this.currentPointer]);
        } else if (type == InstructionTypes.PUT_CHAR) {
            this.memory[this.currentPointer] = (byte)in.read();
        } else if (type == InstructionTypes.CLEAR_LOOP) {
            this.memory[this.currentPointer] = 0;
        }
        return index;
    }
}

